/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtByTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MinionFollowOwnerGoal;
import com.infamous.dungeons_libraries.entities.ai.goal.MeleeAttackGoal;
import com.infamous.dungeons_libraries.mixin.MobInvoker;
import com.infamous.dungeons_libraries.summon.SummonConfig;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class MinionMasterHelper {
    @Nullable
    public static LivingEntity getOwnerForHorse(AbstractHorse horseEntity) {
        try {
            if (horseEntity.m_30615_() != null) {
                UUID ownerUniqueId = horseEntity.m_30615_();
                return ownerUniqueId == null ? null : horseEntity.f_19853_.m_46003_(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public static boolean isMinionEntity(Entity target) {
        Minion targetSummonableCap = MinionMasterHelper.getMinionCapability(target);
        return targetSummonableCap.getMaster() != null;
    }

    public static boolean isMinionOf(LivingEntity target, LivingEntity owner) {
        Minion targetSummonableCap = MinionMasterHelper.getMinionCapability((Entity)target);
        return targetSummonableCap.getMaster() != null && targetSummonableCap.getMaster() == owner;
    }

    @Nullable
    public static LivingEntity getMaster(LivingEntity minionMob) {
        Minion minion = MinionMasterHelper.getMinionCapability((Entity)minionMob);
        return minion.getMaster();
    }

    public static Master getMasterCapability(Entity entity) {
        return (Master)entity.getCapability(ModCapabilities.MASTER_CAPABILITY).orElse((Object)new Master());
    }

    public static Minion getMinionCapability(Entity entity) {
        return (Minion)entity.getCapability(ModCapabilities.MINION_CAPABILITY).orElse((Object)new Minion());
    }

    public static void addMinionGoals(Mob mobEntity) {
        Minion minionCap = MinionMasterHelper.getMinionCapability((Entity)mobEntity);
        if (minionCap.isGoalsAdded()) {
            return;
        }
        if (minionCap.isMinion()) {
            SummonConfig config;
            mobEntity.f_21345_.m_25352_(2, (Goal)new MinionFollowOwnerGoal(mobEntity, 1.5, 24.0f, 3.0f, false));
            MinionMasterHelper.clearGoals(mobEntity.f_21346_);
            mobEntity.f_21346_.m_25352_(1, (Goal)new MasterHurtByTargetGoal(mobEntity));
            mobEntity.f_21346_.m_25352_(2, (Goal)new MasterHurtTargetGoal(mobEntity));
            mobEntity.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mobEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator.getClassification(false).equals((Object)MobCategory.MONSTER) && PetHelper.canPetAttackEntity((LivingEntity)mobEntity, entityIterator)));
            minionCap.getMaster().getCapability(ModCapabilities.MASTER_CAPABILITY).ifPresent(master -> master.addMinion((Entity)mobEntity));
            minionCap.setGoalsAdded(true);
            if (minionCap.isSummon() && (config = SummonConfigRegistry.getConfig(mobEntity.m_6095_().getRegistryName())).shouldAddAttackGoal()) {
                MinionMasterHelper.addSummonAttackGoal(mobEntity);
            }
        }
    }

    private static void addSummonAttackGoal(Mob mobEntity) {
        AttributeInstance attribute = mobEntity.m_21051_(Attributes.f_22281_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22135_() == 0.0) {
            attribute.m_22118_(new AttributeModifier("Summon Attack Damage", 1.0, AttributeModifier.Operation.ADDITION));
        }
        mobEntity.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(mobEntity, 1.0, true));
    }

    static void removeMinion(LivingEntity entityLiving, Minion cap) {
        LivingEntity master = cap.getMaster();
        Master masterCapability = MinionMasterHelper.getMasterCapability((Entity)master);
        masterCapability.removeMinion(entityLiving);
        cap.setMaster(null);
        if (entityLiving instanceof Mob) {
            Mob mobEntity = (Mob)entityLiving;
            MinionMasterHelper.clearGoals(mobEntity.f_21345_);
            MinionMasterHelper.clearGoals(mobEntity.f_21346_);
            cap.setGoalsAdded(false);
            ((MobInvoker)entityLiving).invokeRegisterGoals();
        }
    }

    private static void clearGoals(GoalSelector goalSelector) {
        ArrayList<WrappedGoal> wrappedGoals = new ArrayList<WrappedGoal>(goalSelector.m_148105_());
        wrappedGoals.forEach(prioritizedGoal -> goalSelector.m_25363_(prioritizedGoal.m_26015_()));
    }
}

