/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster.goals;

import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MinionFollowOwnerGoal
extends Goal {
    private final Mob mobEntity;
    private LivingEntity owner;
    private final LevelReader world;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float minDist;
    private final float maxDist;
    private float oldWaterCost;
    private final boolean passesThroughLeaves;

    public MinionFollowOwnerGoal(Mob mobEntity, double followSpeed, float maxDist, float minDist, boolean passesThroughLeaves) {
        this.mobEntity = mobEntity;
        this.world = mobEntity.f_19853_;
        this.followSpeed = followSpeed;
        this.navigator = mobEntity.m_21573_();
        this.maxDist = maxDist;
        this.minDist = minDist;
        this.passesThroughLeaves = passesThroughLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mobEntity.m_21573_() instanceof GroundPathNavigation) && !(mobEntity.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity livingentity = MinionMasterHelper.getMaster((LivingEntity)this.mobEntity);
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.mobEntity.m_21523_()) {
            return false;
        }
        if ((double)this.mobEntity.m_20270_((Entity)livingentity) < (double)this.maxDist) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigator.m_26571_()) {
            return false;
        }
        if (this.mobEntity.m_21523_()) {
            return false;
        }
        return !((double)this.mobEntity.m_20270_((Entity)this.owner) <= (double)this.minDist);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mobEntity.m_21439_(BlockPathTypes.WATER);
        this.mobEntity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.mobEntity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mobEntity.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mobEntity.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.mobEntity.m_21523_() && !this.mobEntity.m_20159_()) {
                if (this.mobEntity.m_20270_((Entity)this.owner) >= this.maxDist * 2.0f) {
                    this.teleportToOwner();
                } else {
                    this.navigator.m_5624_((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
        if (Math.abs((double)p_226328_1_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
            return false;
        }
        this.mobEntity.m_7678_((double)p_226328_1_ + 0.5, (double)p_226328_2_, (double)p_226328_3_ + 0.5, this.mobEntity.m_146908_(), this.mobEntity.m_146909_());
        this.navigator.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_226329_1_) {
        BlockPathTypes pathnodetype = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)p_226329_1_.m_122032_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(p_226329_1_.m_7495_());
        if (!this.passesThroughLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_226329_1_.m_141950_((Vec3i)this.mobEntity.m_142538_());
        return this.world.m_45756_((Entity)this.mobEntity, this.mobEntity.m_142469_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int p_226327_1_, int p_226327_2_) {
        return this.mobEntity.m_21187_().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
    }
}

