/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.soulcaster;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCaster;
import com.infamous.dungeons_libraries.items.interfaces.ISoulConsumer;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.infamous.dungeons_libraries.network.UpdateSoulsMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class SoulCasterHelper {
    public static void addSouls(LivingEntity le, float amount) {
        SoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)le);
        float newAmount = soulCasterCapability.getSouls() + amount + 1.0f;
        soulCasterCapability.setSouls(newAmount, le);
        if (le instanceof ServerPlayer) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)le), (Object)new UpdateSoulsMessage(soulCasterCapability.getSouls()));
        }
    }

    public static void setSouls(LivingEntity le, float amount) {
        SoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)le);
        float newAmount = amount;
        soulCasterCapability.setSouls(newAmount, le);
        if (le instanceof ServerPlayer) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)le), (Object)new UpdateSoulsMessage(soulCasterCapability.getSouls()));
        }
    }

    public static boolean consumeSouls(LivingEntity le, float amount) {
        if (le instanceof Player && ((Player)le).m_7500_()) {
            return true;
        }
        SoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)le);
        if (soulCasterCapability.getSouls() < amount) {
            return false;
        }
        float newAmount = soulCasterCapability.getSouls() - amount;
        soulCasterCapability.setSouls(newAmount, le);
        if (le instanceof ServerPlayer) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)le), (Object)new UpdateSoulsMessage(soulCasterCapability.getSouls()));
        }
        return true;
    }

    public static boolean canConsumeSouls(LivingEntity le, ItemStack itemStack) {
        if (le instanceof Player && ((Player)le).m_7500_()) {
            return true;
        }
        SoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)le);
        Item item = itemStack.m_41720_();
        if (item instanceof ISoulConsumer) {
            ISoulConsumer soulConsumer = (ISoulConsumer)item;
            return soulCasterCapability.getSouls() > soulConsumer.getActivationCost(itemStack);
        }
        return false;
    }

    public static SoulCaster getSoulCasterCapability(Entity entity) {
        return (SoulCaster)entity.getCapability(ModCapabilities.SOUL_CASTER_CAPABILITY).orElse((Object)new SoulCaster());
    }
}

