/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfig;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfigRegistry;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_libraries")
public class SoulBarRender {
    private static final ResourceLocation SOUL_BAR_RESOURCE = new ResourceLocation("dungeons_libraries", "textures/misc/soul_bar.png");
    public static final int SOUL_LEVEL_COLOR = 1093860;

    @SubscribeEvent
    public static void displaySoulBar(RenderGameOverlayEvent.Post event) {
        PoseStack matrixStack = event.getMatrixStack();
        Window sr = event.getWindow();
        int scaledWidth = sr.m_85445_();
        int scaledHeight = sr.m_85446_();
        Minecraft mc = Minecraft.m_91087_();
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.LAYER) && mc.m_91288_() instanceof Player) {
            GuiElementConfig guiElementConfig = GuiElementConfigRegistry.getConfig(new ResourceLocation("dungeons_libraries", "soul_bar"));
            if (guiElementConfig.isHidden()) {
                return;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)SOUL_BAR_RESOURCE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Player renderPlayer = (Player)mc.m_91288_();
            if (renderPlayer == null) {
                return;
            }
            SoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)renderPlayer);
            float souls = soulCasterCapability.getSouls();
            double maxSouls = renderPlayer.m_21133_((Attribute)AttributeRegistry.SOUL_CAP.get());
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            mc.m_91307_().m_6180_("soulBar");
            int xPos = guiElementConfig.getXPosition(scaledWidth);
            int yPos = guiElementConfig.getYPosition(scaledHeight);
            if (souls > 0.0f) {
                int backgroundBarWidth = guiElementConfig.getSizeX();
                int foregroundBarWidth = (int)((double)souls / maxSouls * (double)guiElementConfig.getSizeX());
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)backgroundBarWidth, (int)5, (int)121, (int)10);
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)xPos, (int)yPos, (float)0.0f, (float)5.0f, (int)foregroundBarWidth, (int)5, (int)121, (int)10);
            }
            mc.m_91307_().m_7238_();
            if (souls > 0.0f) {
                mc.m_91307_().m_6180_("soulLevel");
                String soulLevel = "" + souls;
                int baseXPos = xPos + guiElementConfig.getSizeX() / 2 - mc.f_91062_.m_92895_(soulLevel) / 2;
                int n = scaledHeight - guiElementConfig.getSizeY();
                Objects.requireNonNull(mc.f_91062_);
                int baseYPos = n - 9;
                GuiComponent.m_93236_((PoseStack)matrixStack, (Font)mc.f_91062_, (String)soulLevel, (int)baseXPos, (int)baseYPos, (int)1093860);
                mc.m_91307_().m_7238_();
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderSystem.m_69461_();
        }
    }
}

