/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client.artifactBar;

import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfig;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfigRegistry;
import com.infamous.dungeons_libraries.integration.curios.client.CuriosKeyBindings;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_libraries")
public class ArtifactsBarRender {
    private static final ResourceLocation ARTIFACT_BAR_RESOURCE = new ResourceLocation("dungeons_libraries", "textures/gui/artifact_bar.png");
    public static final int SOUL_LEVEL_COLOR = 1093860;

    @SubscribeEvent
    public static void displayArtifactBar(RenderGameOverlayEvent.Pre event) {
        Entity entity;
        PoseStack poseStack = event.getMatrixStack();
        Window sr = event.getWindow();
        int scaledWidth = sr.m_85445_();
        int scaledHeight = sr.m_85446_();
        Minecraft mc = Minecraft.m_91087_();
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.LAYER) && (entity = mc.m_91288_()) instanceof Player) {
            Player renderPlayer = (Player)entity;
            if (renderPlayer == null) {
                return;
            }
            GuiElementConfig guiElementConfig = GuiElementConfigRegistry.getConfig(new ResourceLocation("dungeons_libraries", "artifact_bar"));
            if (guiElementConfig.isHidden()) {
                return;
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            mc.m_91307_().m_6180_("artifactBarBorder");
            mc.m_91307_().m_7238_();
            int x = guiElementConfig.getXPosition(scaledWidth);
            int y = guiElementConfig.getYPosition(scaledHeight);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)renderPlayer).ifPresent(iCuriosItemHandler -> ArtifactsBarRender.renderBar(poseStack, mc, renderPlayer, x, y, iCuriosItemHandler));
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderSystem.m_69461_();
        }
    }

    private static void renderBar(PoseStack poseStack, Minecraft mc, Player renderPlayer, int x, int y, ICuriosItemHandler iCuriosItemHandler) {
        Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
        if (artifactStackHandler.isPresent()) {
            int slots = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getSlots();
            ArtifactsBarRender.renderSlotBg(poseStack, mc, x, y, slots);
            for (int slot = 0; slot < slots; ++slot) {
                mc.m_91307_().m_6180_("artifact Slot " + slot);
                ItemStack artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot);
                if (!artifact.m_41619_() && artifact.m_41720_() instanceof ArtifactItem) {
                    int xPos = x + slot * 20 + 3;
                    int yPos = y + 3;
                    ArtifactsBarRender.renderSlot(poseStack, mc, xPos, yPos, renderPlayer, artifact);
                }
                ArtifactsBarRender.renderSlotKeybind(poseStack, mc, x, y, slot);
                mc.m_91307_().m_7238_();
            }
        }
    }

    private static void renderSlot(PoseStack posestack, Minecraft mc, int xPos, int yPos, Player renderPlayer, ItemStack artifactStack) {
        if (!artifactStack.m_41619_()) {
            float f = (float)artifactStack.m_41612_() - 0.0f;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                posestack.m_85836_();
                posestack.m_85837_((double)(xPos + 8), (double)(yPos + 12), 0.0);
                posestack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                posestack.m_85837_((double)(-(xPos + 8)), (double)(-(yPos + 12)), 0.0);
                RenderSystem.m_157182_();
            }
            Minecraft.m_91087_().m_91291_().m_174229_((LivingEntity)renderPlayer, artifactStack, xPos, yPos, 1);
            if (f > 0.0f) {
                posestack.m_85849_();
            }
            Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, artifactStack, xPos, yPos);
        }
    }

    private static void renderSlotBg(PoseStack poseStack, Minecraft mc, int xPos, int yPos, int slots) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ARTIFACT_BAR_RESOURCE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)62, (int)22, (int)62, (int)22);
    }

    private static void renderSlotKeybind(PoseStack poseStack, Minecraft mc, int x, int y, int slot) {
        String keybind = "";
        if (slot == 0) {
            keyMapping = CuriosKeyBindings.activateArtifact1;
            keybind = ArtifactsBarRender.getString(keyMapping);
        } else if (slot == 1) {
            keyMapping = CuriosKeyBindings.activateArtifact2;
            keybind = ArtifactsBarRender.getString(keyMapping);
        } else if (slot == 2) {
            keyMapping = CuriosKeyBindings.activateArtifact3;
            keybind = ArtifactsBarRender.getString(keyMapping);
        }
        int keybindWidth = mc.f_91062_.m_92895_(keybind);
        int xPosition = x + 1 + slot * 20 + 18 - keybindWidth;
        int yPosition = y + 3;
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)mc.f_91062_, (String)keybind, (int)xPosition, (int)yPosition, (int)0xFFFFFF);
    }

    private static String getString(KeyMapping keyMapping) {
        return keyMapping.getKey().m_84875_().getString();
    }
}

