/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client.gui.elementconfig;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class GuiElementConfig {
    public static final GuiElementConfig DEFAULT = new GuiElementConfig(0, 0, 0, 0, Alignment.BOTTOM_RIGHT, false);
    public static final Codec<GuiElementConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("sizeX").forGetter(GuiElementConfig::getSizeX), (App)Codec.INT.fieldOf("sizeY").forGetter(GuiElementConfig::getSizeY), (App)Codec.INT.fieldOf("offsetX").forGetter(GuiElementConfig::getOffsetX), (App)Codec.INT.fieldOf("offsetY").forGetter(GuiElementConfig::getOffsetY), (App)Alignment.CODEC.fieldOf("alignment").forGetter(GuiElementConfig::getAlignment), (App)Codec.BOOL.fieldOf("isHidden").forGetter(GuiElementConfig::isHidden)).apply((Applicative)instance, GuiElementConfig::new));
    private final int sizeX;
    private final int sizeY;
    private final int offsetX;
    private final int offsetY;
    private final Alignment alignment;
    private final boolean isHidden;

    public GuiElementConfig(int sizeX, int sizeY, int offsetX, int offsetY, Alignment alignment, boolean isHidden) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.alignment = alignment;
        this.isHidden = isHidden;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public int getXPosition(int scaledWidth) {
        switch (this.alignment) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return this.offsetX;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return scaledWidth - this.sizeX + this.offsetX;
            }
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                return (scaledWidth - this.sizeX) / 2 + this.offsetX;
            }
        }
        return 0;
    }

    public int getYPosition(int scaledHeight) {
        switch (this.alignment) {
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case TOP_CENTER: {
                return this.offsetY;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: 
            case BOTTOM_CENTER: {
                return scaledHeight - this.sizeY + this.offsetY;
            }
        }
        return 0;
    }

    public static enum Alignment {
        TOP_CENTER("top_center"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        BOTTOM_CENTER("bottom_center"),
        BOTTOM_RIGHT("bottom_right"),
        BOTTOM_LEFT("bottom_left");

        public static final Codec<Alignment> CODEC;
        private final String name;

        private Alignment(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Alignment byName(String name, Alignment defaultValue) {
            for (Alignment value : Alignment.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            return defaultValue;
        }

        static {
            CODEC = Codec.STRING.flatComapMap(s -> Alignment.byName(s, null), d -> DataResult.success((Object)d.getName()));
        }
    }
}

