/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client.renderer.gearconfig;

import com.infamous.dungeons_libraries.client.renderer.gearconfig.ArmorGearModel;
import com.infamous.dungeons_libraries.entities.SpawnArmoredMob;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterialBaseType;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterial;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.util.RenderUtils;

public class ArmorGearRenderer<T extends ArmorGear>
extends GeoArmorRenderer<T> {
    public ArmorGearRenderer() {
        super(new ArmorGearModel());
    }

    public ArmorGearRenderer(ArmorGearModel<T> model) {
        super(model);
    }

    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderChildBones(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void prepMatrixForBone(PoseStack stack, GeoBone bone) {
        RenderUtils.translateMatrixToBone((PoseStack)stack, (GeoBone)bone);
        RenderUtils.translateToPivotPoint((PoseStack)stack, (GeoBone)bone);
        EntityRenderer entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this.entityLiving);
        if (!(entityRenderer instanceof GeoEntityRenderer) || !bone.getName().contains("armor")) {
            RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (GeoBone)bone);
        }
        RenderUtils.scaleMatrixForBone((PoseStack)stack, (GeoBone)bone);
        ArmorMaterial material = ((ArmorGear)this.currentArmorItem).m_40401_();
        if (bone.getName().contains("Body") && material instanceof DungeonsArmorMaterial && ((DungeonsArmorMaterial)material).getBaseType() == ArmorMaterialBaseType.CLOTH) {
            stack.m_85841_(1.0f, 1.0f, 0.93f);
        }
        RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (GeoBone)bone);
    }

    public void renderCubesOfBone(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.childCubes) {
            if (bone.cubesAreHidden()) continue;
            poseStack.m_85836_();
            if (this.entityLiving instanceof SpawnArmoredMob && ((SpawnArmoredMob)this.entityLiving).getArmorSet().getRegistryName() == ((ArmorGear)this.currentArmorItem).getArmorSet()) {
                this.renderCube(cube, poseStack, buffer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)this.entityLiving, (float)0.0f), red, green, blue, alpha);
            } else {
                this.renderCube(cube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
            poseStack.m_85849_();
        }
    }
}

