/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleGenerator {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final Random RANDOM = new Random();

    @Nullable
    public static Particle addParticleInternal(ParticleOptions particleOptions, boolean guarantee, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ParticleGenerator.addParticleInternal(particleOptions, guarantee, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private static Particle addParticleInternal(ParticleOptions particleOptions, boolean guarantee, boolean minimize, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Camera mainCamera = ParticleGenerator.MINECRAFT.f_91063_.m_109153_();
        if (mainCamera.m_90593_() && ParticleGenerator.MINECRAFT.f_91061_ != null) {
            ParticleStatus particlestatus = ParticleGenerator.calculateParticleLevel(minimize);
            if (guarantee) {
                return ParticleGenerator.MINECRAFT.f_91061_.m_107370_(particleOptions, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            if (mainCamera.m_90583_().m_82531_(x, y, z) > 1024.0) {
                return null;
            }
            return particlestatus == ParticleStatus.MINIMAL ? null : ParticleGenerator.MINECRAFT.f_91061_.m_107370_(particleOptions, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        return null;
    }

    private static ParticleStatus calculateParticleLevel(boolean minimize) {
        ParticleStatus particleStatus = ParticleGenerator.MINECRAFT.f_91066_.f_92073_;
        if (minimize && particleStatus == ParticleStatus.MINIMAL && RANDOM.nextInt(10) == 0) {
            particleStatus = ParticleStatus.DECREASED;
        }
        if (particleStatus == ParticleStatus.DECREASED && RANDOM.nextInt(3) == 0) {
            particleStatus = ParticleStatus.MINIMAL;
        }
        return particleStatus;
    }

    public static void generatePotionImpact(Level level, Potion potion, ItemStack itemStack, BlockPos blockPos, int color, SoundEvent soundEvent) {
        Vec3 bottomCenterOf = Vec3.m_82539_((Vec3i)blockPos);
        for (int particleIndex = 0; particleIndex < 8; ++particleIndex) {
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), bottomCenterOf.f_82479_, bottomCenterOf.f_82480_, bottomCenterOf.f_82481_, level.f_46441_.nextGaussian() * 0.15, level.f_46441_.nextDouble() * 0.2, level.f_46441_.nextGaussian() * 0.15);
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        SimpleParticleType particleData = potion.m_43491_() ? ParticleTypes.f_123751_ : ParticleTypes.f_123806_;
        for (int internalParticleCount = 0; internalParticleCount < 100; ++internalParticleCount) {
            double power = level.f_46441_.nextDouble() * 4.0;
            double d27 = level.f_46441_.nextDouble() * Math.PI * 2.0;
            double d29 = Math.cos(d27) * power;
            double d5 = 0.01 + level.f_46441_.nextDouble() * 0.5;
            double d7 = Math.sin(d27) * power;
            Particle particleInternal = ParticleGenerator.addParticleInternal((ParticleOptions)particleData, particleData.m_6012_().m_123742_(), bottomCenterOf.f_82479_ + d29 * 0.1, bottomCenterOf.f_82480_ + 0.3, bottomCenterOf.f_82481_ + d7 * 0.1, d29, d5, d7);
            if (particleInternal == null) continue;
            float colorStrength = 0.75f + level.f_46441_.nextFloat() * 0.25f;
            particleInternal.m_107253_(red * colorStrength, green * colorStrength, blue * colorStrength);
            particleInternal.m_107268_((float)power);
        }
        level.m_7785_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, soundEvent, SoundSource.NEUTRAL, 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f, false);
    }
}

