/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands;

import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class SoulsCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.souls.add.failed"));
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.souls.set.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder mobEnchantCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"souls").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> SoulsCommand.addSouls((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> SoulsCommand.setSouls((CommandSourceStack)p_198445_0_.getSource(), EntityArgument.m_91477_((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))));
        dispatcher.register(mobEnchantCommand);
    }

    private static int addSouls(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) throws CommandSyntaxException {
        targets.forEach(serverPlayer -> SoulCasterHelper.addSouls((LivingEntity)serverPlayer, amount - 1));
        if (targets.isEmpty()) {
            throw ERROR_ADD_FAILED.create();
        }
        source.m_81354_((Component)new TranslatableComponent("commands.souls.add.success"), true);
        return targets.size();
    }

    private static int setSouls(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) throws CommandSyntaxException {
        targets.forEach(serverPlayer -> SoulCasterHelper.setSouls((LivingEntity)serverPlayer, amount));
        if (targets.isEmpty()) {
            throw ERROR_SET_FAILED.create();
        }
        source.m_81354_((Component)new TranslatableComponent("commands.souls.set.success"), true);
        return targets.size();
    }
}

