/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands;

import com.infamous.dungeons_libraries.entities.elite.EliteMobEvents;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SummonEliteCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.summon.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> p_138815_) {
        p_138815_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summonelite").requires(p_138819_ -> p_138819_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(p_138832_ -> SummonEliteCommand.spawnEntity((CommandSourceStack)p_138832_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138832_, (String)"entity"), ((CommandSourceStack)p_138832_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(p_138830_ -> SummonEliteCommand.spawnEntity((CommandSourceStack)p_138830_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138830_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_138830_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(p_138817_ -> SummonEliteCommand.spawnEntity((CommandSourceStack)p_138817_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138817_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_138817_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_138817_, (String)"nbt"), false))))));
    }

    private static int spawnEntity(CommandSourceStack p_138821_, ResourceLocation p_138822_, Vec3 p_138823_, CompoundTag p_138824_, boolean p_138825_) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(p_138823_);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundTag compoundtag = p_138824_.m_6426_();
        compoundtag.m_128359_("id", p_138822_.toString());
        ServerLevel serverlevel = p_138821_.m_81372_();
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)serverlevel, p_138828_ -> {
            p_138828_.m_7678_(p_138823_.f_82479_, p_138823_.f_82480_, p_138823_.f_82481_, p_138828_.m_146908_(), p_138828_.m_146909_());
            return p_138828_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (p_138825_ && entity instanceof Mob) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)p_138821_.m_81372_(), p_138821_.m_81372_().m_6436_(entity.m_142538_()), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
        }
        if (entity instanceof LivingEntity) {
            EliteMobEvents.makeElite((LivingEntity)entity);
        }
        if (!serverlevel.m_8860_(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        p_138821_.m_81354_((Component)new TranslatableComponent("commands.summon.success", new Object[]{entity.m_5446_()}), true);
        return 1;
    }
}

