/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class Codecs {
    public static final Codec<EnchantmentInstance> ENCHANTMENT_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("enchantment").forGetter(data -> data.f_44947_.getRegistryName()), (App)Codec.INT.fieldOf("level").forGetter(data -> data.f_44948_)).apply((Applicative)instance, Codecs::getEnchantmentInstance));
    public static final Codec<Rarity> ITEM_RARITY_CODEC = Codec.STRING.flatComapMap(Rarity::valueOf, d -> DataResult.success((Object)d.name()));

    private static EnchantmentInstance getEnchantmentInstance(ResourceLocation resourceLocation, int level) {
        Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourceLocation);
        return new EnchantmentInstance(enchantment, level);
    }
}

