/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data.util;

import com.google.common.util.concurrent.Runnables;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;

public class CodecJsonDataManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    private final Codec<T> codec;
    private final Logger logger;
    private final String folderName;
    public Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();
    private Runnable syncOnReloadCallback = Runnables.doNothing();

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger) {
        this(folderName, codec, logger, STANDARD_GSON);
    }

    public CodecJsonDataManager(String folderName, Codec<T> codec, Logger logger, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
        this.codec = codec;
        this.logger = logger;
    }

    @Nullable
    public T getData(ResourceLocation id) {
        return this.data.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = this.mapValues(jsons);
        this.logger.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)this.data.size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncOnReloadCallback.run();
        }
    }

    private Map<ResourceLocation, T> mapValues(Map<ResourceLocation, JsonElement> inputs) {
        HashMap newMap = new HashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : inputs.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> newMap.put(key, result.getFirst())).ifRight(partial -> this.logger.error("Failed to parse data json for {} due to: {}", (Object)key.toString(), (Object)partial.message()));
        }
        return newMap;
    }

    public <PACKET> CodecJsonDataManager<T> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncOnReloadCallback = () -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            Player player = event.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packetFactory.apply(this.data));
            }
        };
    }

    public boolean hasData() {
        return this.data.size() > 0;
    }
}

