/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data.util;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Runnables;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class MergeableCodecDataManager<RAW, FINE>
extends SimplePreparableReloadListener<Map<ResourceLocation, FINE>> {
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    protected static final Gson STANDARD_GSON = new Gson();
    @Nonnull
    public Map<ResourceLocation, FINE> data = new HashMap<ResourceLocation, FINE>();
    private final String folderName;
    private final Logger logger;
    private final Codec<RAW> codec;
    private final Function<List<RAW>, FINE> merger;
    private final Gson gson;
    private Runnable syncOnReloadCallback = Runnables.doNothing();

    public MergeableCodecDataManager(String folderName, Logger logger, Codec<RAW> codec, Function<List<RAW>, FINE> merger) {
        this(folderName, logger, codec, merger, STANDARD_GSON);
    }

    public MergeableCodecDataManager(String folderName, Logger logger, Codec<RAW> codec, Function<List<RAW>, FINE> merger, Gson gson) {
        this.folderName = folderName;
        this.logger = logger;
        this.codec = codec;
        this.merger = merger;
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ResourceLocation, FINE> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        for (ResourceLocation resourceLocation : resourceManager.m_6540_(this.folderName, MergeableCodecDataManager::isStringJsonFile)) {
            String namespace = resourceLocation.m_135827_();
            String filePath = resourceLocation.m_135815_();
            String dataPath = filePath.substring(this.folderName.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonIdentifier = new ResourceLocation(namespace, dataPath);
            ArrayList unmergedRaws = new ArrayList();
            try {
                for (Resource resource : resourceManager.m_7396_(resourceLocation)) {
                    try {
                        InputStream inputStream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                            this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(MergeableCodecDataManager::throwJsonParseException).ifPresent(unmergedRaws::add);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException | RuntimeException exception) {
                        this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)this.folderName, (Object)jsonIdentifier, (Object)resourceLocation, (Object)resource.m_7816_(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {}", (Object)this.folderName, (Object)jsonIdentifier, (Object)resourceLocation, (Object)exception);
            }
            map.put(jsonIdentifier, unmergedRaws);
        }
        return MergeableCodecDataManager.mapValues(map, this.merger::apply);
    }

    static boolean isStringJsonFile(String filename) {
        return filename.endsWith(JSON_EXTENSION);
    }

    static void throwJsonParseException(String codecParseFailure) {
        throw new JsonParseException(codecParseFailure);
    }

    static <Key, In, Out> Map<Key, Out> mapValues(Map<Key, In> inputs, Function<In, Out> mapper) {
        HashMap newMap = new HashMap();
        inputs.forEach((key, input) -> newMap.put(key, mapper.apply(input)));
        return newMap;
    }

    protected void apply(Map<ResourceLocation, FINE> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.logger.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        this.data = processedData;
        this.logger.info("Data loader for {} loaded {} finalized objects", (Object)this.folderName, (Object)this.data.size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncOnReloadCallback.run();
        }
    }

    public <PACKET> MergeableCodecDataManager<RAW, FINE> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getLoginListener(channel, packetFactory));
        this.syncOnReloadCallback = () -> channel.send(PacketDistributor.ALL.noArg(), packetFactory.apply(this.data));
        return this;
    }

    private <PACKET> Consumer<PlayerEvent.PlayerLoggedInEvent> getLoginListener(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        return event -> {
            Player player = event.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packetFactory.apply(this.data));
            }
        };
    }
}

