/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities;

import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.entities.ModEntityTypes;
import com.infamous.dungeons_libraries.event.PlayerSoulEvent;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class SoulOrbEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public int f_19797_;
    public int age;
    public int floatTime = 20;
    private int health = 5;
    public float value;
    private Player followingPlayer;
    private int followingTime;

    public SoulOrbEntity(Player followingPlayer, Level level, double x, double y, double z, float value) {
        this((EntityType<? extends SoulOrbEntity>)((EntityType)ModEntityTypes.SOUL_ORB.get()), level);
        this.followingPlayer = followingPlayer;
        this.m_6034_(x, y, z);
        this.m_146922_((float)(this.f_19796_.nextDouble() * 360.0));
        this.m_20334_((this.f_19796_.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.f_19796_.nextDouble() * 0.2 * 2.0, (this.f_19796_.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = value;
        this.m_20242_(true);
    }

    public SoulOrbEntity(EntityType<? extends SoulOrbEntity> p_i50382_1_, Level p_i50382_2_) {
        super(p_i50382_1_, p_i50382_2_);
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(0.0, 0.0, 0.0);
        if (this.floatTime > 0) {
            this.m_20334_(0.0, 0.05, 0.0);
            --this.floatTime;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.setUnderwaterMovement();
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (!this.f_19853_.m_45772_(this.m_142469_())) {
            this.m_20314_(this.m_20185_(), (this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0, this.m_20189_());
        }
        double d0 = 8.0;
        if (this.followingPlayer == null || this.followingPlayer.m_5833_()) {
            this.m_146870_();
        }
        if (this.followingPlayer != null && this.floatTime == 0) {
            Vec3 vector3d = new Vec3(this.followingPlayer.m_20185_() - this.m_20185_(), this.followingPlayer.m_20186_() + (double)this.followingPlayer.m_20192_() / 2.0 - this.m_20186_(), this.followingPlayer.m_20189_() - this.m_20189_());
            double d1 = (double)this.f_19797_ * 0.0075;
            this.m_20256_(this.m_20184_().m_82549_(vector3d.m_82541_().m_82490_(d1)));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        this.m_20256_(this.m_20184_().m_82542_((double)f, (double)f, (double)f));
        ++this.f_19797_;
        ++this.age;
        if (this.age >= 6000) {
            this.m_146870_();
        }
    }

    private void setUnderwaterMovement() {
        Vec3 vector3d = this.m_20184_();
        this.m_20334_(vector3d.f_82479_ * (double)0.99f, Math.min(vector3d.f_82480_ + (double)5.0E-4f, (double)0.06f), vector3d.f_82481_ * (double)0.99f);
    }

    protected void m_5841_() {
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return false;
        }
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        this.m_5834_();
        this.health = (int)((float)this.health - p_70097_2_);
        if (this.health <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return false;
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128376_("Health", (short)this.health);
        p_213281_1_.m_128376_("Age", (short)this.age);
        p_213281_1_.m_128376_("Value", (short)this.value);
        p_213281_1_.m_128376_("FloatTime", (short)this.floatTime);
        p_213281_1_.m_128362_("FollowingPlayer", this.followingPlayer.m_142081_());
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        this.health = p_70037_1_.m_128448_("Health");
        this.age = p_70037_1_.m_128448_("Age");
        this.value = p_70037_1_.m_128448_("Value");
        this.floatTime = p_70037_1_.m_128448_("FloatTime");
        UUID followingPlayerUUID = p_70037_1_.m_128342_("FollowingPlayer");
        Player playerByUUID = this.f_19853_.m_46003_(followingPlayerUUID);
        if (playerByUUID != null) {
            this.followingPlayer = playerByUUID;
        }
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_ && this.floatTime == 0) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerSoulEvent.PickupSoul(player, this))) {
                return;
            }
            if (this.value > 0.0f) {
                SoulCasterHelper.addSouls((LivingEntity)player, this.value);
            }
            this.m_146870_();
        }
    }

    public float getValue() {
        return this.value;
    }

    public int getIcon() {
        if (this.value >= 10.0f) {
            return 10;
        }
        if (this.value <= 0.0f) {
            return 0;
        }
        return (int)Math.floor((this.value - 1.0f) / 3.0f) + 7;
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.health);
        buffer.writeInt(this.age);
        buffer.writeFloat(this.value);
        buffer.m_130077_(this.followingPlayer.m_142081_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.health = additionalData.readInt();
        this.age = additionalData.readInt();
        this.value = additionalData.readFloat();
        Player playerByUUID = this.f_19853_.m_46003_(additionalData.m_130259_());
        if (playerByUUID != null) {
            this.followingPlayer = playerByUUID;
        }
    }
}

