/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities.elite;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.MergeableCodecDataManager;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfig;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfigList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandom;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EliteMobConfigRegistry {
    public static final MergeableCodecDataManager<EliteMobConfigList, List<EliteMobConfig>> ELITE_MOB_CONFIGS = new MergeableCodecDataManager<EliteMobConfigList, List>("elite_mob", DungeonsLibraries.LOGGER, EliteMobConfigList.CODEC, EliteMobConfigRegistry::eliteMobMerger);

    public static List<EliteMobConfig> eliteMobMerger(List<EliteMobConfigList> raws) {
        return raws.stream().flatMap(rawList -> rawList.getConfigs().stream()).collect(Collectors.toList());
    }

    public static EliteMobConfig getRandomConfig(ResourceLocation resourceLocation, Random random) {
        List eliteMobConfigs = EliteMobConfigRegistry.ELITE_MOB_CONFIGS.data.getOrDefault(resourceLocation, Collections.emptyList());
        if (eliteMobConfigs.isEmpty()) {
            return null;
        }
        return WeightedRandom.m_146317_((Random)random, eliteMobConfigs).orElse(null);
    }

    public static boolean eliteMobConfigExists(ResourceLocation resourceLocation) {
        return EliteMobConfigRegistry.ELITE_MOB_CONFIGS.data.containsKey(resourceLocation);
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ELITE_MOB_CONFIGS);
    }
}

