/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities.elite;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobHelper;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfig;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfigRegistry;
import com.infamous.dungeons_libraries.network.EliteMobMessage;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import java.util.UUID;
import net.minecraft.client.model.EntityModel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class EliteMobEvents {
    public static final float SIZE_ADJUSTMENT = 1.1f;

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity;
        Level level = event.getWorld();
        if (!level.m_5776_() && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (((Boolean)DungeonsLibrariesConfig.ENABLE_ELITE_MOBS.get()).booleanValue()) {
                EliteMobEvents.makeEliteChance(level, entity2);
            }
        }
    }

    public static void makeEliteChance(Level level, LivingEntity entity) {
        LevelChunk chunk;
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        EliteMobConfig config = EliteMobConfigRegistry.getRandomConfig(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.m_6095_()), entity.m_21187_());
        if (!cap.hasSpawned() && config != null && (chunk = level.m_7726_().m_7131_(entity.m_142538_().m_123341_() >> 4, entity.m_142538_().m_123343_() >> 4)) != null && chunk.m_6415_().m_62427_(ChunkStatus.f_62326_) && (double)entity.m_21187_().nextFloat() < (Double)DungeonsLibrariesConfig.ELITE_MOBS_BASE_CHANCE.get() * (double)level.m_6436_(entity.m_142538_()).m_19057_()) {
            EliteMobEvents.makeElite(entity, config);
        }
        cap.setHasSpawned(true);
    }

    public static void makeElite(LivingEntity entity) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        EliteMobConfig config = EliteMobConfigRegistry.getRandomConfig(entity.m_6095_().getRegistryName(), entity.m_21187_());
        if (config != null) {
            EliteMobEvents.makeElite(entity, config);
        }
        cap.setHasSpawned(true);
    }

    private static void makeElite(LivingEntity entity, EliteMobConfig config) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.HEAD, config.getHeadItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.CHEST, config.getChestItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.LEGS, config.getLegsItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.FEET, config.getFeetItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.MAINHAND, config.getHandItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlot.OFFHAND, config.getOffhandItem());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        config.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                builder.put((Object)attribute, (Object)new AttributeModifier(UUID.randomUUID(), "Armor modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        entity.m_21204_().m_22178_((Multimap)builder.build());
        cap.setElite(true);
        cap.setTexture(config.getTexture());
    }

    private static void setItemSlot(LivingEntity entity, EquipmentSlot slotType, ItemStack item) {
        if (!item.equals(ItemStack.f_41583_)) {
            entity.m_8061_(slotType, item);
        }
    }

    @SubscribeEvent
    public static void onEntityEventSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability(entity);
        if (cap.isElite()) {
            float totalWidth = event.getNewSize().f_20377_ * 1.1f;
            float totalHeight = event.getNewSize().f_20378_ * 1.1f;
            event.setNewEyeHeight(event.getNewEyeHeight() * 1.1f);
            event.setNewSize(EntityDimensions.m_20398_((float)totalWidth, (float)totalHeight));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap.isElite()) {
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_85841_(1.1f, 1.1f, 1.1f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap.isElite()) {
            event.getPoseStack().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        EliteMob cap;
        Player player = event.getPlayer();
        Entity target = event.getTarget();
        if (player instanceof ServerPlayer && target instanceof LivingEntity && (cap = EliteMobHelper.getEliteMobCapability(event.getTarget())).isElite()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new EliteMobMessage(target.m_142049_(), cap.isElite(), cap.getTexture()));
        }
    }

    @SubscribeEvent
    public static void onLivingConvert(LivingConversionEvent.Post event) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability(event.getEntity());
        EliteMob outcomeCap = EliteMobHelper.getEliteMobCapability((Entity)event.getOutcome());
        outcomeCap.setHasSpawned(true);
        if (cap.isElite()) {
            outcomeCap.setElite(true);
        }
    }
}

