/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.integration.curios.client.message;

import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosArtifactStartMessage {
    private final int slot;
    private BlockHitResult hitResult;

    public CuriosArtifactStartMessage(int slot, BlockHitResult hitResult) {
        this.slot = slot;
        this.hitResult = hitResult;
    }

    public static void encode(CuriosArtifactStartMessage packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.slot);
        buf.m_130062_(packet.hitResult);
    }

    public static CuriosArtifactStartMessage decode(FriendlyByteBuf buf) {
        return new CuriosArtifactStartMessage(buf.readInt(), buf.m_130283_());
    }

    public static class CuriosArtifactHandler {
        public static void handle(CuriosArtifactStartMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().setPacketHandled(true);
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player != null) {
                        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                            ItemStack artifact;
                            Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
                            if (artifactStackHandler.isPresent() && !(artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(packet.slot)).m_41619_() && artifact.m_41720_() instanceof ArtifactItem) {
                                ArtifactUseContext iuc = new ArtifactUseContext(player.f_19853_, (Player)player, artifact, packet.hitResult);
                                ((ArtifactItem)artifact.m_41720_()).activateArtifact(iuc);
                            }
                        });
                    }
                });
            }
        }
    }
}

