/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items;

import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGear;
import com.infamous.dungeons_libraries.utils.RangedAttackHelper;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.RegistryObject;

public class RangedItemModelProperties {
    private static final ResourceLocation PULL_PROPERTY = new ResourceLocation("pull");
    private static final ResourceLocation PULLING_PROPERTY = new ResourceLocation("pulling");
    private static final ResourceLocation CHARGED_PROPERTY = new ResourceLocation("charged");

    public static void init() {
        Map itemModelsProperties = ItemProperties.f_117825_;
        Map bowModelProperties = (Map)itemModelsProperties.get(Items.f_42411_);
        bowModelProperties.put(PULL_PROPERTY, RangedItemModelProperties::getBowPullProperty);
        bowModelProperties.put(PULLING_PROPERTY, RangedItemModelProperties::getBowPullingProperty);
        Map crossbowModelProperties = (Map)itemModelsProperties.get(Items.f_42717_);
        crossbowModelProperties.put(PULL_PROPERTY, RangedItemModelProperties::getCrossbowPullProperty);
        crossbowModelProperties.put(PULLING_PROPERTY, RangedItemModelProperties::getCrossbowPullingProperty);
        crossbowModelProperties.put(CHARGED_PROPERTY, RangedItemModelProperties::getCrossbowChargedProperty);
    }

    public static void addRangedModelProperties(RegistryObject<Item> itemRegistryObject) {
        if (itemRegistryObject.get() instanceof BowItem) {
            RangedItemModelProperties.addBowModelProperties(itemRegistryObject);
        } else if (itemRegistryObject.get() instanceof CrossbowItem) {
            RangedItemModelProperties.addCrossbowModelProperties(itemRegistryObject);
        }
    }

    public static void addBowModelProperties(RegistryObject<Item> itemRegistryObject) {
        ItemProperties.register((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULL_PROPERTY, RangedItemModelProperties::getBowPullProperty);
        ItemProperties.register((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULLING_PROPERTY, RangedItemModelProperties::getBowPullingProperty);
    }

    public static void addCrossbowModelProperties(RegistryObject<Item> itemRegistryObject) {
        ItemProperties.register((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULL_PROPERTY, RangedItemModelProperties::getCrossbowPullProperty);
        ItemProperties.register((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULLING_PROPERTY, RangedItemModelProperties::getCrossbowPullingProperty);
        ItemProperties.register((Item)((Item)itemRegistryObject.get()), (ResourceLocation)CHARGED_PROPERTY, RangedItemModelProperties::getCrossbowChargedProperty);
    }

    private static float getCrossbowPullProperty(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int i) {
        if (livingEntity == null || CrossbowItem.m_40932_((ItemStack)stack)) {
            return 0.0f;
        }
        if (stack.m_41720_() instanceof CrossbowGear) {
            return (float)(stack.m_41779_() - livingEntity.m_21212_()) / RangedAttackHelper.getModdedCrossbowChargeTime(livingEntity, stack);
        }
        return CrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - livingEntity.m_21212_()) / RangedAttackHelper.getVanillaCrossbowChargeTime(livingEntity, stack);
    }

    private static float getCrossbowPullingProperty(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int i) {
        return livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
    }

    private static float getCrossbowChargedProperty(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int i) {
        return livingEntity != null && CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f;
    }

    private static float getBowPullProperty(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int i) {
        if (livingEntity == null || livingEntity.m_21211_() != stack) {
            return 0.0f;
        }
        return (float)(stack.m_41779_() - livingEntity.m_21212_()) / RangedAttackHelper.getBowChargeTime(livingEntity, livingEntity.m_21211_());
    }

    private static float getBowPullingProperty(ItemStack stack, ClientLevel clientWorld, LivingEntity livingEntity, int i) {
        return livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == stack ? 1.0f : 0.0f;
    }
}

