/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.artifacts;

import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsage;
import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageHelper;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class ArtifactEvents {
    @SubscribeEvent
    public static void onCurioChange(CurioChangeEvent event) {
        ItemStack itemstack1;
        if (!event.getIdentifier().equals("artifact")) {
            return;
        }
        ItemStack itemstack = event.getTo();
        if (itemstack.m_41720_() instanceof ArtifactItem && !itemstack.m_41619_()) {
            event.getEntityLiving().m_21204_().m_22178_(((ArtifactItem)itemstack.m_41720_()).getDefaultAttributeModifiers(event.getSlotIndex()));
        }
        if ((itemstack1 = event.getFrom()).m_41720_() instanceof ArtifactItem && !itemstack1.m_41619_()) {
            event.getEntityLiving().m_21204_().m_22161_(((ArtifactItem)itemstack1.m_41720_()).getDefaultAttributeModifiers(event.getSlotIndex()));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArtifactUsage cap = ArtifactUsageHelper.getArtifactUsageCapability((Entity)event.player);
        if (cap.isUsingArtifact() && cap.getUsingArtifact().m_41720_() instanceof ArtifactItem) {
            cap.getUsingArtifact().m_41720_().m_5929_(event.player.f_19853_, (LivingEntity)event.player, cap.getUsingArtifact(), cap.getUsingArtifactRemaining());
            cap.setUsingArtifactRemaining(cap.getUsingArtifactRemaining() - 1);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    private static void stopUsingAllArtifacts(Player player) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
            if (artifactStackHandler.isPresent()) {
                int slots = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    ItemStack artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot);
                    if (artifact.m_41619_() || !(artifact.m_41720_() instanceof ArtifactItem)) continue;
                    ((ArtifactItem)artifact.m_41720_()).stopUsingArtifact((LivingEntity)player);
                }
            }
        });
    }
}

