/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.artifacts;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.event.ArtifactEvent;
import com.infamous.dungeons_libraries.items.ItemTagWrappers;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.mixin.CooldownAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class ArtifactItem
extends Item
implements ICurioItem {
    protected final UUID SLOT0_UUID = UUID.fromString("7037798e-ac2c-4711-aa72-ba73589f1411");
    protected final UUID SLOT1_UUID = UUID.fromString("1906bae9-9f26-4194-bb8a-ef95b8cad134");
    protected final UUID SLOT2_UUID = UUID.fromString("b99aa930-03d0-4b2d-aa69-7b5d943dd75c");
    protected boolean procOnItemUse = false;

    public ArtifactItem(Item.Properties properties) {
        super(properties.m_41503_(((Integer)DungeonsLibrariesConfig.ARTIFACT_DURABILITY.get()).intValue()));
    }

    public static void putArtifactOnCooldown(Player playerIn, Item item) {
        int cooldownInTicks = item instanceof ArtifactItem ? ((ArtifactItem)item).getCooldownInSeconds() * 20 : 0;
        AttributeInstance artifactCooldownMultiplierAttribute = playerIn.m_21051_((Attribute)AttributeRegistry.ARTIFACT_COOLDOWN_MULTIPLIER.get());
        double attributeModifier = artifactCooldownMultiplierAttribute != null ? artifactCooldownMultiplierAttribute.m_22135_() : 1.0;
        playerIn.m_36335_().m_41524_(item, Math.max(0, (int)((double)cooldownInTicks * attributeModifier)));
    }

    public static void triggerSynergy(Player player, ItemStack stack) {
        ArtifactEvent.Activated event = new ArtifactEvent.Activated((LivingEntity)player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void reduceArtifactCooldowns(Player playerEntity, double reductionInSeconds) {
        for (Item item : playerEntity.m_36335_().f_41515_.keySet()) {
            if (!(item instanceof ArtifactItem)) continue;
            int createTicks = ((CooldownAccessor)playerEntity.m_36335_().f_41515_.get(item)).getStartTime();
            int expireTicks = ((CooldownAccessor)playerEntity.m_36335_().f_41515_.get(item)).getEndTime();
            int duration = expireTicks - createTicks;
            playerEntity.m_36335_().m_41524_(item, Math.max(0, duration - (int)(reductionInSeconds * 20.0)));
        }
    }

    public Rarity m_41460_(ItemStack itemStack) {
        return Rarity.RARE;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return ForgeRegistries.ITEMS.tags().getTag(ItemTagWrappers.ARTIFACT_REPAIR_ITEMS).contains((Object)repair.m_41720_()) || super.m_6832_(toRepair, repair);
    }

    public int m_6473_() {
        return 9;
    }

    public InteractionResultHolder<ItemStack> activateArtifact(ArtifactUseContext artifactUseContext) {
        InteractionResultHolder<ItemStack> procResult;
        if (artifactUseContext.getPlayer() != null) {
            ItemStack itemStack = artifactUseContext.getItemStack();
            if (artifactUseContext.getPlayer().m_36335_().m_41519_(itemStack.m_41720_())) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
            }
        }
        if ((procResult = this.procArtifact(artifactUseContext)).m_19089_().m_19077_() && artifactUseContext.getPlayer() != null && !artifactUseContext.getLevel().f_46443_) {
            ArtifactItem.triggerSynergy(artifactUseContext.getPlayer(), artifactUseContext.getItemStack());
        }
        return procResult;
    }

    public abstract InteractionResultHolder<ItemStack> procArtifact(ArtifactUseContext var1);

    public abstract int getCooldownInSeconds();

    public abstract int getDurationInSeconds();

    public void stopUsingArtifact(LivingEntity livingEntity) {
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(int slotIndex) {
        return ImmutableMultimap.of();
    }

    protected UUID getUUIDForSlot(int slotIndex) {
        switch (slotIndex) {
            case 0: {
                return this.SLOT0_UUID;
            }
            case 1: {
                return this.SLOT1_UUID;
            }
            case 2: {
                return this.SLOT2_UUID;
            }
        }
        return this.SLOT2_UUID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        DescriptionHelper.addArtifactDescription(list, stack);
    }
}

