/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IRangedWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import com.infamous.dungeons_libraries.utils.RangedAttackHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class BowGear
extends BowItem
implements IRangedWeapon,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private BowGearConfig bowGearConfig;

    public BowGear(Item.Properties builder) {
        super(builder.m_41503_(384));
        this.reload();
    }

    @Override
    public void reload() {
        this.bowGearConfig = BowGearConfigRegistry.getConfig(this.getRegistryName());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.bowGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.f_22281_.equals(attribute)) {
                    uuid = f_41374_;
                } else if (Attributes.f_22283_.equals(attribute)) {
                    uuid = f_41375_;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
        ((ItemAccessor)((Object)this)).setMaxDamage(this.bowGearConfig.getDurability());
    }

    public float getDefaultChargeTime() {
        return this.bowGearConfig.getDefaultChargeTime();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player playerentity = (Player)livingEntity;
            boolean useInfiniteAmmo = playerentity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.m_6298_(stack);
            int charge = this.m_8105_(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)world, (Player)playerentity, (int)charge, (!itemstack.m_41619_() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || useInfiniteAmmo) {
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                float arrowVelocity = RangedAttackHelper.getArrowVelocity((LivingEntity)playerentity, stack, charge);
                this.fireArrows(stack, world, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    public void fireArrows(ItemStack stack, Level world, Player playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        int arrowsToFire = 1;
        if (multishotLevel > 0) {
            arrowsToFire += 2;
        }
        if (this.hasMultishotWhenCharged(stack) && arrowVelocity == 1.0f) {
            arrowsToFire += 2;
        }
        for (int arrowNumber = 0; arrowNumber < arrowsToFire; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!world.f_46443_) {
                this.createBowArrow(stack, world, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            world.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (playerentity.m_21187_().nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.m_150110_().f_35937_ || isAdditionalShot)) {
                itemstack.m_41774_(1);
                if (itemstack.m_41619_()) {
                    playerentity.m_150109_().m_36057_(itemstack);
                }
            }
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public AbstractArrow createBowArrow(ItemStack stack, Level world, Player playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        int punchLevel;
        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrowEntity = arrowitem.m_6394_(world, itemstack, (LivingEntity)playerentity);
        abstractArrowEntity = this.customArrow(abstractArrowEntity);
        AttributeInstance attribute = playerentity.m_21051_((Attribute)AttributeRegistry.RANGED_DAMAGE_MULTIPLIER.get());
        if (attribute != null) {
            abstractArrowEntity.m_36781_(abstractArrowEntity.m_36789_() * attribute.m_22135_());
        }
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractArrowEntity);
        if (arrowVelocity == 1.0f) {
            abstractArrowEntity.m_36762_(true);
        }
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractArrowEntity.m_36781_(abstractArrowEntity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            abstractArrowEntity.m_36735_(punchLevel);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            abstractArrowEntity.m_20254_(100);
        }
        stack.m_41622_(1, (LivingEntity)playerentity, p_lambda$onPlayerStoppedUsing$0_1_ -> p_lambda$onPlayerStoppedUsing$0_1_.m_21190_(playerentity.m_7655_()));
        if (hasInfiniteAmmo || playerentity.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
            abstractArrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractArrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)abstractArrowEntity);
        return abstractArrowEntity;
    }

    public void setArrowTrajectory(Player playerentity, float arrowVelocity, int i, AbstractArrow abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_(), 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    @Override
    public boolean isUnique() {
        return this.bowGearConfig.isUnique();
    }

    public BowGearConfig getGearConfig() {
        return this.bowGearConfig;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }
}

