/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.event.CrossbowEvent;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IRangedWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.CrossbowItemInvoker;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class CrossbowGear
extends CrossbowItem
implements IRangedWeapon,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private BowGearConfig crossbowGearConfig;
    public boolean isLoadingStart = false;
    public boolean isLoadingMiddle = false;

    public CrossbowGear(Item.Properties builder) {
        super(builder.m_41503_(384));
        this.reload();
    }

    @Override
    public void reload() {
        this.crossbowGearConfig = CrossbowGearConfigRegistry.getConfig(this.getRegistryName());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.crossbowGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.f_22281_.equals(attribute)) {
                    uuid = f_41374_;
                } else if (Attributes.f_22283_.equals(attribute)) {
                    uuid = f_41375_;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
        ((ItemAccessor)((Object)this)).setMaxDamage(this.crossbowGearConfig.getDurability());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public static float getArrowVelocity(LivingEntity livingEntity, ItemStack stack) {
        float baseVelocity = 3.15f;
        if (CrossbowGear.m_40871_((ItemStack)stack, (Item)Items.f_42688_)) {
            baseVelocity = 1.6f;
        }
        CrossbowEvent.Velocity event = new CrossbowEvent.Velocity(livingEntity, stack, baseVelocity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getVelocity();
    }

    public static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, CrossbowGear.getRandomSoundPitch(flag, rand), CrossbowGear.getRandomSoundPitch(!flag, rand)};
    }

    private static float getRandomSoundPitch(boolean flagIn, Random random) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static boolean canAddChargedProjectile(LivingEntity livingEntity, ItemStack stack, ItemStack stack1, boolean b, boolean b1) {
        ItemStack itemstack;
        boolean flag;
        if (stack1.m_41619_()) {
            return false;
        }
        boolean bl = flag = b1 && stack1.m_41720_() instanceof ArrowItem;
        if (!(flag || b1 || b)) {
            itemstack = stack1.m_41620_(1);
            if (stack1.m_41619_() && livingEntity instanceof Player) {
                ((Player)livingEntity).m_150109_().m_36057_(stack1);
            }
        } else {
            itemstack = stack1.m_41777_();
        }
        CrossbowItemInvoker.addChargedProjectile(stack, itemstack);
        return true;
    }

    public float getDefaultChargeTime() {
        return this.crossbowGearConfig.getDefaultChargeTime();
    }

    public void m_5929_(Level world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.f_46443_) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent quickChargeSoundEvent = this.getCrossbowSoundEvent(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.f_11842_ : null;
            float chargeTime = (float)(stack.m_41779_() - timeLeft) / this.getCrossbowChargeTime(livingEntity, stack);
            if (chargeTime < 0.2f) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
            }
            if (chargeTime >= 0.2f && !this.isLoadingStart && chargeTime < 1.0f) {
                this.isLoadingStart = true;
                world.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), quickChargeSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !this.isLoadingMiddle && chargeTime < 1.0f) {
                this.isLoadingMiddle = true;
                world.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), loadingMiddleSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity livingEntity, int timeLeft) {
        float i = this.getCrossbowChargeTime(livingEntity, stack) + 3.0f - (float)timeLeft;
        float f = this.getCrossbowCharge(livingEntity, i, stack);
        if (f >= 1.0f && !CrossbowGear.m_40932_((ItemStack)stack) && CrossbowGear.hasAmmo(livingEntity, stack)) {
            CrossbowGear.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundcategory = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            worldIn.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (livingEntity.m_21187_().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(LivingEntity livingEntity, float useTime, ItemStack stack) {
        float crossbowChargeTime = this.getCrossbowChargeTime(livingEntity, stack);
        float f = useTime / crossbowChargeTime;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public float getCrossbowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        CrossbowEvent.ChargeTime event = new CrossbowEvent.ChargeTime(livingEntity, stack, this.getDefaultChargeTime());
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public SoundEvent getCrossbowSoundEvent(int i) {
        switch (i) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    public void fireCrossbowProjectiles(Level world, LivingEntity livingEntity, InteractionHand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = CrossbowItemInvoker.getChargedProjectiles(stack);
        float[] randomSoundPitches = CrossbowGear.getRandomSoundPitches(livingEntity.m_21187_());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
            if (currentProjectile.m_41619_()) continue;
            if (i == 0) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 2) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 3) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i == 4) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
                continue;
            }
            if (i == 5) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -30.0f);
                continue;
            }
            if (i != 6) continue;
            this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 30.0f);
        }
        CrossbowItemInvoker.onCrossbowShot(world, livingEntity, stack);
    }

    private AbstractArrow createCrossbowArrow(Level world, LivingEntity livingEntity, ItemStack stack, ItemStack stack1) {
        ArrowItem arrowItem = (ArrowItem)(stack1.m_41720_() instanceof ArrowItem ? stack1.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrowEntity = arrowItem.m_6394_(world, stack1, livingEntity);
        AttributeInstance attribute = livingEntity.m_21051_((Attribute)AttributeRegistry.RANGED_DAMAGE_MULTIPLIER.get());
        if (attribute != null) {
            abstractArrowEntity.m_36781_(abstractArrowEntity.m_36789_() * attribute.m_22135_());
        }
        if (livingEntity instanceof Player) {
            abstractArrowEntity.m_36762_(true);
        }
        abstractArrowEntity.m_36740_(SoundEvents.f_11840_);
        abstractArrowEntity.m_36793_(true);
        int piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (piercingLevel > 0) {
            abstractArrowEntity.m_36767_((byte)piercingLevel);
        }
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractArrowEntity.m_36781_(abstractArrowEntity.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++punchLevel;
        }
        if (punchLevel > 0) {
            abstractArrowEntity.m_36735_(punchLevel);
        }
        return abstractArrowEntity;
    }

    public int m_8105_(ItemStack stack) {
        return (int)this.getCrossbowChargeTime(null, stack) + 3;
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public void fireProjectile(Level worldIn, LivingEntity shooter, InteractionHand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.f_46443_) {
            AbstractArrow projectileentity;
            boolean flag;
            boolean bl = flag = projectile.m_41720_() == Items.f_42688_;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectileentity = this.createCrossbowArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    projectileentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob icrossbowuser = (CrossbowAttackMob)shooter;
                icrossbowuser.m_5811_(Objects.requireNonNull(icrossbowuser.m_5448_()), crossbow, (Projectile)projectileentity, projectileAngle);
            } else {
                Vec3 vector3d1 = shooter.m_20289_(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), projectileAngle, true);
                Vec3 vector3d = shooter.m_20252_(1.0f);
                Vector3f vector3f = new Vector3f(vector3d);
                vector3f.m_122251_(quaternion);
                projectileentity.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), velocity, inaccuracy);
            }
            this.damageItem(flag ? 3 : 1, crossbow, shooter, handIn);
            worldIn.m_7967_((Entity)projectileentity);
            worldIn.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    protected void damageItem(int amount, ItemStack crossbow, LivingEntity shooter, InteractionHand handIn) {
        crossbow.m_41622_(amount, shooter, p_220017_1_ -> p_220017_1_.m_21190_(handIn));
    }

    protected static boolean hasAmmo(LivingEntity entityIn, ItemStack stack) {
        int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        CrossbowGear adci = (CrossbowGear)stack.m_41720_();
        if (adci.hasExtraMultishot(stack)) {
            ++multishotLevel;
        }
        int arrowsToFire = 1 + multishotLevel * 2;
        boolean flag = entityIn instanceof Player && ((Player)entityIn).m_150110_().f_35937_;
        ItemStack itemstack = entityIn.m_6298_(stack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int i = 0; i < arrowsToFire; ++i) {
            if (i > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (CrossbowGear.canAddChargedProjectile(entityIn, stack, itemstack, i > 0, flag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnique() {
        return this.crossbowGearConfig.isUnique();
    }

    public BowGearConfig getGearConfig() {
        return this.crossbowGearConfig;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }
}

