/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.armor;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.DefaultsCodecJsonDataManager;
import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterialBaseType;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterial;
import com.infamous.dungeons_libraries.network.materials.ArmorMaterialSyncPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;

public class DungeonsArmorMaterials {
    public static final DefaultsCodecJsonDataManager<ArmorMaterial> ARMOR_MATERIALS = new DefaultsCodecJsonDataManager<ArmorMaterial>("material/armor", DungeonsArmorMaterial.CODEC, DungeonsLibraries.LOGGER);
    public static final Map<ArmorMaterial, ArmorMaterialBaseType> baseArmorMaterials = new HashMap<ArmorMaterial, ArmorMaterialBaseType>();

    public static void setupVanillaMaterials() {
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.LEATHER, ArmorMaterialBaseType.LEATHER, new ResourceLocation("minecraft:leather"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.CHAIN, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:chainmail"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.IRON, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:iron"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.GOLD, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:gold"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.DIAMOND, ArmorMaterialBaseType.GEM, new ResourceLocation("minecraft:diamond"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.TURTLE, ArmorMaterialBaseType.LEATHER, new ResourceLocation("minecraft:turtle"));
        DungeonsArmorMaterials.addDefaultArmorMaterial(ArmorMaterials.NETHERITE, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:netherite"));
    }

    public static void addDefaultArmorMaterial(ArmorMaterials material, ArmorMaterialBaseType baseType, ResourceLocation resourceLocation) {
        ARMOR_MATERIALS.addDefault(resourceLocation, (ArmorMaterial)material);
        baseArmorMaterials.put((ArmorMaterial)material, baseType);
    }

    public static ArmorMaterial getArmorMaterial(ResourceLocation resourceLocation) {
        return (ArmorMaterial)DungeonsArmorMaterials.ARMOR_MATERIALS.data.getOrDefault(resourceLocation, ArmorMaterials.IRON);
    }

    public static boolean ArmorMaterialExists(ResourceLocation resourceLocation) {
        return DungeonsArmorMaterials.ARMOR_MATERIALS.data.containsKey(resourceLocation);
    }

    public static Collection<ResourceLocation> armorMaterialsKeys() {
        return DungeonsArmorMaterials.ARMOR_MATERIALS.data.keySet();
    }

    public static Collection<ArmorMaterial> getArmorMaterials(ArmorMaterialBaseType baseType) {
        return DungeonsArmorMaterials.ARMOR_MATERIALS.data.values().stream().filter(iArmorMaterial -> {
            if (iArmorMaterial instanceof DungeonsArmorMaterial) {
                return ((DungeonsArmorMaterial)iArmorMaterial).getBaseType() == baseType;
            }
            if (baseArmorMaterials.containsKey(iArmorMaterial)) {
                return baseArmorMaterials.get(iArmorMaterial) == baseType;
            }
            return ArmorMaterialBaseType.UNKNOWN == baseType;
        }).collect(Collectors.toList());
    }

    public static ArmorMaterialSyncPacket toPacket(Map<ResourceLocation, ArmorMaterial> map) {
        return new ArmorMaterialSyncPacket(map);
    }
}

