/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.weapon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonsWeaponMaterial
implements Tier {
    public static final Codec<Tier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getName()), (App)SoundEvent.f_11655_.fieldOf("equip_sound").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getEquipSound()), (App)Codec.INT.fieldOf("durability").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).m_6609_()), (App)Codec.INT.fieldOf("enchantability").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).m_6601_()), (App)ResourceLocation.f_135803_.fieldOf("repair_item").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getRepairItemResourceLocation()), (App)Codec.FLOAT.fieldOf("attack_speed").forGetter(iItemTier -> Float.valueOf(((DungeonsWeaponMaterial)iItemTier).m_6624_())), (App)Codec.FLOAT.fieldOf("attack_damage").forGetter(iItemTier -> Float.valueOf(((DungeonsWeaponMaterial)iItemTier).m_6631_())), (App)Codec.INT.fieldOf("level").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).m_6604_())).apply((Applicative)instance, DungeonsWeaponMaterial::new));
    private final String name;
    private final SoundEvent equipSound;
    private final int durability;
    private final int enchantability;
    private final ResourceLocation repairItemResourceLocation;
    private final Ingredient repairItem;
    private final float attackSpeed;
    private final float attackDamageBonus;
    private final int level;

    public DungeonsWeaponMaterial(String name, SoundEvent equipSound, int durability, int enchantability, ResourceLocation repairItemResourceLocation, float attackSpeed, float attackDamageBonus, int level) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItemResourceLocation = repairItemResourceLocation;
        if (ForgeRegistries.ITEMS.containsKey(repairItemResourceLocation)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(repairItemResourceLocation);
            this.repairItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
        } else {
            this.repairItem = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_});
        }
        this.attackSpeed = attackSpeed;
        this.attackDamageBonus = attackDamageBonus;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public int m_6609_() {
        return this.durability;
    }

    public int m_6601_() {
        return this.enchantability;
    }

    public ResourceLocation getRepairItemResourceLocation() {
        return this.repairItemResourceLocation;
    }

    public Ingredient m_6282_() {
        return this.repairItem;
    }

    public float m_6624_() {
        return this.attackSpeed;
    }

    public float m_6631_() {
        return this.attackDamageBonus;
    }

    public int m_6604_() {
        return this.level;
    }
}

