/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.weapon;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.DefaultsCodecJsonDataManager;
import com.infamous.dungeons_libraries.items.materials.weapon.DungeonsWeaponMaterial;
import com.infamous.dungeons_libraries.network.materials.WeaponMaterialSyncPacket;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public class WeaponMaterials {
    public static final DefaultsCodecJsonDataManager<Tier> WEAPON_MATERIALS = new DefaultsCodecJsonDataManager<Tier>("material/weapon", DungeonsWeaponMaterial.CODEC, DungeonsLibraries.LOGGER);

    public static void setupVanillaMaterials() {
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:wood"), (Tier)Tiers.WOOD);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:stone"), (Tier)Tiers.STONE);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:iron"), (Tier)Tiers.IRON);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:diamond"), (Tier)Tiers.DIAMOND);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:gold"), (Tier)Tiers.GOLD);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:netherite"), (Tier)Tiers.NETHERITE);
    }

    public static Tier getWeaponMaterial(ResourceLocation resourceLocation) {
        return (Tier)WeaponMaterials.WEAPON_MATERIALS.data.getOrDefault(resourceLocation, Tiers.IRON);
    }

    public static boolean WeaponMaterialExists(ResourceLocation boostResourceLocation) {
        return WeaponMaterials.WEAPON_MATERIALS.data.containsKey(boostResourceLocation);
    }

    public static Collection<ResourceLocation> weaponMaterialsKeys() {
        return WeaponMaterials.WEAPON_MATERIALS.data.keySet();
    }

    public static WeaponMaterialSyncPacket toPacket(Map<ResourceLocation, Tier> map) {
        return new WeaponMaterialSyncPacket(map);
    }
}

