/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import com.infamous.dungeons_libraries.network.client.ClientHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class EliteMobMessage {
    private int entityId;
    private boolean isElite;
    private ResourceLocation texture;

    public EliteMobMessage(int entityId, boolean isElite, ResourceLocation texture) {
        this.entityId = entityId;
        this.isElite = isElite;
        this.texture = texture;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.isElite);
        buffer.m_130085_(this.texture);
    }

    public static EliteMobMessage decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        boolean isElite = buffer.readBoolean();
        ResourceLocation texture = buffer.m_130281_();
        return new EliteMobMessage(entityId, isElite, texture);
    }

    public static void handle(EliteMobMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientHandler.handleEliteMobMessage(message, contextSupplier);
        contextSupplier.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isElite() {
        return this.isElite;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

