/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network.materials;

import com.infamous.dungeons_libraries.items.GearConfigReloadListener;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterial;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterials;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraftforge.network.NetworkEvent;

public class ArmorMaterialSyncPacket {
    private static final Codec<Map<ResourceLocation, ArmorMaterial>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, DungeonsArmorMaterial.CODEC);
    public final Map<ResourceLocation, ArmorMaterial> data;

    public ArmorMaterialSyncPacket(Map<ResourceLocation, ArmorMaterial> data) {
        this.data = data.entrySet().stream().filter(entry -> entry.getValue() instanceof DungeonsArmorMaterial).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.data).result().orElse(new CompoundTag()));
    }

    public static ArmorMaterialSyncPacket decode(FriendlyByteBuf buffer) {
        return new ArmorMaterialSyncPacket(MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buffer.m_130260_()).result().orElse(new HashMap()));
    }

    public void onPacketReceived(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(this::handlePacketOnMainThread);
        context.setPacketHandled(true);
    }

    private void handlePacketOnMainThread() {
        DungeonsArmorMaterials.ARMOR_MATERIALS.data = this.data;
        GearConfigReloadListener.reloadAllItems();
    }
}

