/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.summon;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public class SummonHelper {
    private static boolean addSummonedMob(LivingEntity master, Entity entity) {
        Master masterCap = MinionMasterHelper.getMasterCapability((Entity)master);
        if (SummonHelper.canSummonMob(master, entity, masterCap)) {
            return masterCap.addSummonedMob(entity);
        }
        return false;
    }

    private static boolean canSummonMob(LivingEntity master, Entity beeEntity, Master masterCap) {
        AttributeInstance summonCapAttribute = master.m_21051_((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCapAttribute == null) {
            return false;
        }
        return (double)(masterCap.getSummonedMobsCost() + SummonConfigRegistry.getConfig(beeEntity.m_6095_().getRegistryName()).getCost()) <= summonCapAttribute.m_22135_();
    }

    public static boolean canSummonMob(LivingEntity master, Master masterCap) {
        AttributeInstance summonCapAttribute = master.m_21051_((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCapAttribute == null) {
            return false;
        }
        return (double)masterCap.getSummonedMobsCost() < summonCapAttribute.m_22135_();
    }

    public static Entity summonEntity(LivingEntity master, BlockPos position, EntityType<?> entityType) {
        Entity entity = entityType.m_20615_(master.f_19853_);
        if (entity != null) {
            Minion summonable = MinionMasterHelper.getMinionCapability(entity);
            if (SummonHelper.addSummonedMob(master, entity)) {
                summonable.setMaster(master);
                summonable.setSummon(true);
                SummonHelper.createSummon(master, entity, position);
                return entity;
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    private static void createSummon(LivingEntity master, Entity entity, BlockPos position) {
        entity.m_7678_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.05, (double)position.m_123343_() + 0.5, 0.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            MinionMasterHelper.addMinionGoals(mobEntity);
        }
        master.f_19853_.m_7967_(entity);
    }
}

