/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbilityHelper {
    public static boolean isFacingEntity(Entity looker, Entity target, Vec3 look, int angle) {
        double cos;
        if (angle <= 0) {
            return false;
        }
        Vec3 posVec = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        Vec3 relativePosVec = posVec.m_82505_(looker.m_20182_().m_82520_(0.0, (double)looker.m_20192_(), 0.0)).m_82541_();
        double dotsq = relativePosVec.m_82526_(look) * Math.abs(relativePosVec.m_82526_(look)) / (relativePosVec.m_82556_() * look.m_82556_());
        return dotsq < -((cos = (double)Mth.m_14089_((float)((float)((double)angle / 360.0 * Math.PI)))) * cos);
    }

    private static boolean isNotTheTargetOrAttacker(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return nearbyEntity != target && nearbyEntity != attacker;
    }

    private static boolean isBothPlayerAndNoPvP(LivingEntity attacker, LivingEntity nearbyEntity) {
        return attacker instanceof Player && nearbyEntity instanceof Player && (Boolean)DungeonsLibrariesConfig.ENABLE_AREA_OF_EFFECT_ON_OTHER_PLAYERS.get() == false;
    }

    public static boolean canHealEntity(LivingEntity healer, LivingEntity nearbyEntity) {
        return nearbyEntity != healer && AbilityHelper.isAlly(healer, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, healer);
    }

    public static boolean isAlly(LivingEntity origin, LivingEntity target) {
        LivingEntity originOwner = PetHelper.getOwner(origin);
        LivingEntity targetOwner = PetHelper.getOwner(target);
        if (originOwner != null || targetOwner != null) {
            return AbilityHelper.isAlly(originOwner != null ? originOwner : origin, targetOwner != null ? targetOwner : target);
        }
        return PetHelper.isPetOrColleagueRelation(origin, target) || origin.m_7307_((Entity)target) || AbilityHelper.isBothPlayerAndNoPvP(origin, target) || origin.getClassification(false).equals((Object)MobCategory.MONSTER) && target.getClassification(false).equals((Object)MobCategory.MONSTER) || AbilityHelper.isEntityBlacklisted(origin, target);
    }

    private static boolean isEntityBlacklisted(LivingEntity origin, LivingEntity target) {
        if (target.m_6095_().equals(EntityType.f_20529_)) {
            return true;
        }
        return origin instanceof Player && !target.getClassification(false).equals((Object)MobCategory.MONSTER) && !((List)DungeonsLibrariesConfig.ENEMY_WHITELIST.get()).contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.m_6095_()).toString()) || ((List)DungeonsLibrariesConfig.ENEMY_BLACKLIST.get()).contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.m_6095_()).toString());
    }

    private static boolean isAliveAndCanBeSeen(LivingEntity nearbyEntity, LivingEntity attacker) {
        return nearbyEntity.m_6084_() && attacker.m_142582_((Entity)nearbyEntity);
    }

    public static boolean canApplyToSecondEnemy(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return AbilityHelper.isNotTheTargetOrAttacker(attacker, target, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }

    public static boolean canApplyToEnemy(LivingEntity attacker, LivingEntity nearbyEntity) {
        return nearbyEntity != attacker && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }
}

