/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsHelper;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries", value={Dist.CLIENT})
public class DescriptionHelper {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        BuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(event.getItemStack());
        List<EnchantmentInstance> builtInEnchantments = cap.getBuiltInEnchantments(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION);
        builtInEnchantments.forEach(enchantmentInstance -> event.getToolTip().add(enchantmentInstance.f_44947_.m_44700_(enchantmentInstance.f_44948_).m_6881_().m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FF8100")))));
    }

    public static void addArtifactDescription(List<Component> list, ItemStack itemStack) {
        ResourceLocation registryName = itemStack.m_41720_().getRegistryName();
        if (registryName == null) {
            return;
        }
        DescriptionHelper.addLoreDescription(list, registryName);
        DescriptionHelper.addArtifactInfo(list, itemStack);
    }

    public static void addArtifactInfo(List<Component> list, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ArtifactItem) {
            list.add((Component)new TranslatableComponent("artifact.dungeons_libraries.base").m_130940_(ChatFormatting.DARK_AQUA));
            ResourceLocation registryName = itemStack.m_41720_().getRegistryName();
            list.add((Component)new TranslatableComponent("ability." + registryName.m_135827_() + "." + registryName.m_135815_()).m_130940_(ChatFormatting.GREEN));
            ArtifactItem artifactItem = (ArtifactItem)itemStack.m_41720_();
            int durationInSeconds = artifactItem.getDurationInSeconds();
            int cooldownInSeconds = artifactItem.getCooldownInSeconds();
            if (durationInSeconds > 0) {
                list.add((Component)new TranslatableComponent("artifact.dungeons_libraries.duration", new Object[]{durationInSeconds}).m_130940_(ChatFormatting.BLUE));
            }
            if (cooldownInSeconds > 0) {
                list.add((Component)new TranslatableComponent("artifact.dungeons_libraries.cooldown", new Object[]{cooldownInSeconds}).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public static void addFullDescription(List<Component> list, ItemStack itemStack) {
        ResourceLocation registryName = itemStack.m_41720_().getRegistryName();
        DescriptionHelper.addLoreDescription(list, registryName);
    }

    public static void addLoreDescription(List<Component> list, ResourceLocation registryName) {
        list.add((Component)new TranslatableComponent("lore." + registryName.m_135827_() + "." + registryName.m_135815_()).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
    }

    public static void addChargeableDescription(List<Component> list, ItemStack itemStack) {
    }
}

