/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.event.BowEvent;
import com.infamous.dungeons_libraries.items.gearconfig.BowGear;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGear;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RangedAttackHelper {
    public static float getArrowVelocity(LivingEntity livingEntity, ItemStack stack, int charge) {
        float bowChargeTime = RangedAttackHelper.getBowChargeTime(livingEntity, stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f;
        float velocityLimit = 1.0f;
        BowEvent.Overcharge event = new BowEvent.Overcharge(livingEntity, stack, 0);
        MinecraftForge.EVENT_BUS.post((Event)event);
        int overchargeLevel = event.getCharges();
        if (overchargeLevel > 0) {
            velocityLimit += (float)overchargeLevel;
        }
        if (arrowVelocity > velocityLimit) {
            arrowVelocity = velocityLimit;
        }
        return arrowVelocity;
    }

    public static float getBowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        float defaultChargeTime = stack.m_41720_() instanceof BowGear ? ((BowGear)stack.m_41720_()).getDefaultChargeTime() : 20.0f;
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        BowEvent.ChargeTime event = new BowEvent.ChargeTime(livingEntity, stack, defaultChargeTime);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public static float getVanillaCrossbowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        BowEvent.ChargeTime event = new BowEvent.ChargeTime(livingEntity, stack, 25.0f);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public static float getModdedCrossbowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        float chargeTime = stack.m_41720_() instanceof CrossbowGear ? ((CrossbowGear)stack.m_41720_()).getCrossbowChargeTime(livingEntity, stack) : 25.0f;
        return chargeTime;
    }

    public static float getVanillaOrModdedCrossbowArrowVelocity(LivingEntity livingEntity, ItemStack stack) {
        float arrowVelocity = stack.m_41720_() instanceof CrossbowGear ? CrossbowGear.getArrowVelocity(livingEntity, stack) : (CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f);
        return arrowVelocity;
    }
}

