/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class MultiblockAdvancementTrigger
implements CriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "multiblock_formed");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void m_6468_(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance createInstance(JsonObject json, DeserializationContext context) {
        EntityPredicate.Composite and = EntityPredicate.Composite.m_36677_((JsonObject)json, (String)"player", (DeserializationContext)context);
        return new Instance(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"multiblock")), ItemPredicate.m_45051_((JsonElement)json.get("item")), and);
    }

    public void trigger(ServerPlayer player, MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
        Listeners listeners = this.listeners.get(player.m_8960_());
        if (listeners != null) {
            listeners.trigger(multiblock, hammer);
        }
    }

    public static Instance create(ResourceLocation multiblock, ItemPredicate hammer) {
        return new Instance(multiblock, hammer, EntityPredicate.Composite.f_36667_);
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            List list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(multiblock, hammer)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    listener1.m_13686_(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final ResourceLocation multiblock;
        private final ItemPredicate hammer;

        public Instance(ResourceLocation multiblock, ItemPredicate hammer, EntityPredicate.Composite and) {
            super(ID, and);
            this.multiblock = multiblock;
            this.hammer = hammer;
        }

        public boolean test(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            return this.multiblock.equals((Object)multiblock.getUniqueName()) && this.hammer.m_45049_(hammer);
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.addProperty("multiblock", this.multiblock.toString());
            jsonobject.add("item", this.hammer.m_45048_());
            return jsonobject;
        }
    }
}

