/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.ItemStorageType;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.RSSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class StorageBlockEntity
extends NetworkNodeBlockEntity<StorageNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, StorageBlockEntity> PRIORITY = IPrioritizable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, StorageBlockEntity> COMPARE = IComparable.createParameter();
    public static final BlockEntitySynchronizationParameter<Integer, StorageBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final BlockEntitySynchronizationParameter<AccessType, StorageBlockEntity> ACCESS_TYPE = IAccessType.createParameter();
    public static final BlockEntitySynchronizationParameter<Long, StorageBlockEntity> STORED = new BlockEntitySynchronizationParameter<Long, StorageBlockEntity>(RSSerializers.LONG_SERIALIZER, 0L, t -> ((StorageNetworkNode)t.getNode()).getStorage() != null ? (long)((StorageNetworkNode)t.getNode()).getStorage().getStored() : 0L);
    private final ItemStorageType type;

    public StorageBlockEntity(ItemStorageType type, BlockPos pos, BlockState state) {
        super(StorageBlockEntity.getType(type), pos, state, StorageNetworkNode.class);
        this.type = type;
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    public static BlockEntityType<StorageBlockEntity> getType(ItemStorageType type) {
        switch (type) {
            case ONE_K: {
                return RSBlockEntities.ONE_K_STORAGE_BLOCK;
            }
            case FOUR_K: {
                return RSBlockEntities.FOUR_K_STORAGE_BLOCK;
            }
            case SIXTEEN_K: {
                return RSBlockEntities.SIXTEEN_K_STORAGE_BLOCK;
            }
            case SIXTY_FOUR_K: {
                return RSBlockEntities.SIXTY_FOUR_K_STORAGE_BLOCK;
            }
            case CREATIVE: {
                return RSBlockEntities.CREATIVE_STORAGE_BLOCK;
            }
        }
        throw new IllegalArgumentException("Unknown storage type " + type);
    }

    public ItemStorageType getItemStorageType() {
        return this.type;
    }

    @Override
    @Nonnull
    public StorageNetworkNode createNode(Level level, BlockPos pos) {
        return new StorageNetworkNode(level, pos, this.type);
    }
}

