/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client;

import com.wynprice.secretrooms.client.model.OneWayGlassModel;
import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.client.model.SecretMappedModel;
import com.wynprice.secretrooms.client.model.TrueVisionGogglesModel;
import com.wynprice.secretrooms.client.world.DelegateWorld;
import com.wynprice.secretrooms.server.blocks.SecretBaseBlock;
import com.wynprice.secretrooms.server.blocks.SecretBlocks;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;

public class SecretModelHandler {
    public static void onEntityModelRegistered(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TrueVisionGogglesModel.TRUE_VISION_GOGGLES_MODEL, () -> LayerDefinition.m_171565_((MeshDefinition)TrueVisionGogglesModel.createMesh(CubeDeformation.f_171458_, 0.0f), (int)64, (int)32));
    }

    public static void onBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((state, world, pos, index) -> SecretBaseBlock.getMirrorState((BlockGetter)world, pos).map(DelegateWorld.createFunction((BlockGetter)world, (reader, mirror) -> colors.m_92577_(mirror, (BlockAndTintGetter)reader, pos, index))).orElse(-1), new Block[]{SecretBlocks.GHOST_BLOCK.get(), SecretBlocks.SECRET_STAIRS.get(), SecretBlocks.SECRET_LEVER.get(), SecretBlocks.SECRET_REDSTONE.get(), SecretBlocks.ONE_WAY_GLASS.get(), SecretBlocks.SECRET_WOODEN_BUTTON.get(), SecretBlocks.SECRET_STONE_BUTTON.get(), SecretBlocks.SECRET_PRESSURE_PLATE.get(), SecretBlocks.SECRET_PLAYER_PRESSURE_PLATE.get(), SecretBlocks.SECRET_DOOR.get(), SecretBlocks.SECRET_IRON_DOOR.get(), SecretBlocks.SECRET_CHEST.get(), SecretBlocks.SECRET_TRAPDOOR.get(), SecretBlocks.SECRET_IRON_TRAPDOOR.get(), SecretBlocks.SECRET_TRAPPED_CHEST.get(), SecretBlocks.SECRET_GATE.get(), SecretBlocks.SECRET_DUMMY_BLOCK.get(), SecretBlocks.SECRET_DAYLIGHT_DETECTOR.get(), SecretBlocks.SECRET_OBSERVER.get(), SecretBlocks.SECRET_CLAMBER.get()});
    }

    public static void onModelBaked(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        SecretModelHandler.put(registry, SecretBlockModel::new, SecretBlocks.GHOST_BLOCK.get(), SecretBlocks.SECRET_STAIRS.get(), SecretBlocks.SECRET_LEVER.get(), SecretBlocks.SECRET_REDSTONE.get(), SecretBlocks.SECRET_WOODEN_BUTTON.get(), SecretBlocks.SECRET_STONE_BUTTON.get(), SecretBlocks.SECRET_PRESSURE_PLATE.get(), SecretBlocks.SECRET_PLAYER_PRESSURE_PLATE.get(), SecretBlocks.SECRET_CHEST.get(), SecretBlocks.SECRET_TRAPPED_CHEST.get(), SecretBlocks.SECRET_GATE.get(), SecretBlocks.SECRET_DUMMY_BLOCK.get(), SecretBlocks.SECRET_DAYLIGHT_DETECTOR.get(), SecretBlocks.SECRET_OBSERVER.get(), SecretBlocks.SECRET_CLAMBER.get());
        SecretModelHandler.put(registry, SecretMappedModel::new, SecretBlocks.SECRET_DOOR.get(), SecretBlocks.SECRET_IRON_DOOR.get(), SecretBlocks.SECRET_TRAPDOOR.get(), SecretBlocks.SECRET_IRON_TRAPDOOR.get());
        SecretModelHandler.put(registry, OneWayGlassModel::new, SecretBlocks.ONE_WAY_GLASS.get());
    }

    private static void put(Map<ResourceLocation, BakedModel> registry, Function<BakedModel, BakedModel> creator, Block ... blocks) {
        for (Block block : blocks) {
            for (BlockState state : block.m_49965_().m_61056_()) {
                registry.put((ResourceLocation)BlockModelShaper.m_110895_((BlockState)state), creator.apply(registry.get(BlockModelShaper.m_110895_((BlockState)state))));
            }
        }
    }
}

