/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynprice.secretrooms.client.SecretModelData;
import com.wynprice.secretrooms.client.model.quads.TrueVisionBakedQuad;
import com.wynprice.secretrooms.client.world.DelegateWorld;
import com.wynprice.secretrooms.server.items.TrueVisionGogglesClientHandler;
import com.wynprice.secretrooms.server.utils.ModelDataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SecretBlockModel
implements BakedModel {
    private static final Supplier<BlockRenderDispatcher> DISPATCHER = () -> Minecraft.m_91087_().m_91289_();
    private final BakedModel model;

    public SecretBlockModel(BakedModel model) {
        this.model = model;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        Optional<BlockState> data = ModelDataUtils.getData(extraData, SecretModelData.SRM_BLOCKSTATE);
        if (!data.isPresent() || !this.canRenderInLater(data.get())) {
            return Collections.emptyList();
        }
        BlockState mirrorState = data.get();
        Supplier<List<BakedQuad>> quads = () -> this.render(mirrorState, state, DISPATCHER.get().m_110910_(mirrorState), side, rand, extraData);
        if (this.trueVision() && MinecraftForgeClient.getRenderType() == RenderType.m_110466_()) {
            List quadList = quads.get();
            this.getHelmetQuads(this.gatherAllQuads(quads), quadList);
            return quadList;
        }
        return quads.get();
    }

    private void getHelmetQuads(List<BakedQuad> allQuads, List<BakedQuad> quads) {
        for (BakedQuad quad : allQuads) {
            quads.add(TrueVisionBakedQuad.generateQuad(quad));
        }
    }

    private boolean trueVision() {
        return TrueVisionGogglesClientHandler.isWearingGoggles((Player)Minecraft.m_91087_().f_91074_);
    }

    protected boolean canRenderInLater(BlockState state) {
        RenderType renderLayer = MinecraftForgeClient.getRenderType();
        return this.trueVision() && renderLayer == RenderType.m_110466_() || renderLayer == null || ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)renderLayer);
    }

    protected List<BakedQuad> gatherAllQuads(Supplier<List<BakedQuad>> superQuads) {
        RenderType layer = MinecraftForgeClient.getRenderType();
        ForgeHooksClient.setRenderType(null);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)superQuads.get());
        ForgeHooksClient.setRenderType((RenderType)layer);
        return quads;
    }

    protected List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull BakedModel model, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return new ArrayList<BakedQuad>(model.getQuads(mirrorState, side, rand, extraData));
    }

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        return this.trueVision() ? this.model.getParticleIcon(data) : ModelDataUtils.getData(data, SecretModelData.SRM_BLOCKSTATE).map(arg_0 -> ((BlockRenderDispatcher)DISPATCHER.get()).m_110910_(arg_0)).orElse(this.model).getParticleIcon(data);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IModelData data;
        Optional<BlockState> mirror;
        BlockEntity entity;
        if (tileData == EmptyModelData.INSTANCE && (entity = world.m_7702_(pos)) != null) {
            tileData = entity.getModelData();
        }
        if ((mirror = ModelDataUtils.getData(tileData, SecretModelData.SRM_BLOCKSTATE)).isPresent()) {
            DelegateWorld pooled = DelegateWorld.getPooled((BlockGetter)world);
            tileData = DISPATCHER.get().m_110910_(mirror.get()).getModelData((BlockAndTintGetter)pooled, pos, mirror.get(), tileData);
            pooled.release();
        }
        if ((data = this.model.getModelData(world, pos, state, tileData)) != tileData && tileData != EmptyModelData.INSTANCE) {
            if (tileData.hasProperty(SecretModelData.SRM_BLOCKSTATE) && !data.hasProperty(SecretModelData.SRM_BLOCKSTATE)) {
                data.setData(SecretModelData.SRM_BLOCKSTATE, (Object)((BlockState)tileData.getData(SecretModelData.SRM_BLOCKSTATE)));
            }
            if (tileData.hasProperty(SecretModelData.MODEL_MAP_STATE) && !data.hasProperty(SecretModelData.MODEL_MAP_STATE)) {
                data.setData(SecretModelData.MODEL_MAP_STATE, (Object)((BlockState)tileData.getData(SecretModelData.MODEL_MAP_STATE)));
            }
        }
        return data;
    }

    public boolean m_7539_() {
        return this.model.m_7539_();
    }

    public boolean m_7547_() {
        return this.trueVision() && this.model.m_7547_();
    }

    public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
        return this.model.m_6840_(state, side, rand);
    }

    public ItemTransforms m_7442_() {
        return this.model.m_7442_();
    }

    public boolean m_7541_() {
        return this.model.m_7541_();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.model.useAmbientOcclusion(state);
    }

    public TextureAtlasSprite m_6160_() {
        return this.model.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.model.m_7343_();
    }

    public boolean m_7521_() {
        return false;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return this.model.handlePerspective(cameraTransformType, mat);
    }
}

