/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class StonecutterRecipeContainer {
    private static final String DATA_SELECTED_RECIPE_INDEX = "selectedRecipeIndex";
    private final Slot inputSlot;
    private final IServerUpdater serverUpdater;
    private final Slot outputSlot;
    private final ResultContainer resultInventory = new ResultContainer();
    private List<StonecutterRecipe> recipes = Lists.newArrayList();
    private final DataSlot selectedRecipe = DataSlot.m_39401_();
    private Item inputItem = Items.f_41852_;
    private final CraftingItemHandler inputInventory;
    private Runnable inventoryUpdateListener = () -> {};
    private final Supplier<Optional<ResourceLocation>> getLastSelectedRecipeId;
    private final Consumer<ResourceLocation> setLastSelectedRecipeId;
    private long lastOnTake = -1L;

    public StonecutterRecipeContainer(StonecutterUpgradeContainer upgradeContainer, Consumer<Slot> addSlot, IServerUpdater serverUpdater, ContainerLevelAccess worldPosCallable) {
        this.inputSlot = new SlotSuppliedHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, 0, -1, -1){

            public void m_6654_() {
                super.m_6654_();
                StonecutterRecipeContainer.this.onCraftMatrixChanged((Container)StonecutterRecipeContainer.this.inputInventory);
            }

            public ItemStack m_6201_(int amount) {
                ItemStack ret = super.m_6201_(amount);
                if (this.m_7993_().m_41619_()) {
                    this.m_6654_();
                }
                return ret;
            }
        };
        this.serverUpdater = serverUpdater;
        addSlot.accept(this.inputSlot);
        this.inputInventory = new CraftingItemHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, this::onCraftMatrixChanged);
        this.outputSlot = new ResultSlot(worldPosCallable);
        addSlot.accept(this.outputSlot);
        this.getLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getRecipeId;
        this.setLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::setRecipeId;
        this.onCraftMatrixChanged((Container)this.inputInventory);
    }

    private void onCraftMatrixChanged(Container inventoryIn) {
        ItemStack itemstack = this.inputSlot.m_7993_();
        if (itemstack.m_41720_() != this.inputItem) {
            this.inputItem = itemstack.m_41720_();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
        this.inventoryUpdateListener.run();
    }

    private void updateAvailableRecipes(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = RecipeHelper.getRecipesOfType(RecipeType.f_44112_, inventory);
            this.getLastSelectedRecipeId.get().ifPresent(id -> {
                for (int i = 0; i < this.recipes.size(); ++i) {
                    if (!this.recipes.get(i).m_6423_().equals(id)) continue;
                    this.selectedRecipe.m_6422_(i);
                    this.updateRecipeResultSlot();
                }
            });
        }
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public List<StonecutterRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean selectRecipe(int recipeIndex) {
        if (this.isIndexInRecipeBounds(recipeIndex)) {
            this.selectedRecipe.m_6422_(recipeIndex);
            this.setLastSelectedRecipeId.accept(this.recipes.get(recipeIndex).m_6423_());
            this.updateRecipeResultSlot();
            this.serverUpdater.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), DATA_SELECTED_RECIPE_INDEX, recipeIndex));
        }
        return true;
    }

    private boolean isIndexInRecipeBounds(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isIndexInRecipeBounds(this.selectedRecipe.m_6501_())) {
            StonecutterRecipe stonecuttingrecipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.resultInventory.m_6029_((Recipe)stonecuttingrecipe);
            this.outputSlot.m_5852_(stonecuttingrecipe.m_5874_((Container)this.inputInventory));
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
    }

    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SELECTED_RECIPE_INDEX)) {
            this.selectRecipe(data.m_128451_(DATA_SELECTED_RECIPE_INDEX));
        }
    }

    public boolean isNotResultSlot(Slot slot) {
        return slot != this.outputSlot;
    }

    private class ResultSlot
    extends Slot {
        private final ContainerLevelAccess worldPosCallable;

        public ResultSlot(ContainerLevelAccess worldPosCallable) {
            super((Container)StonecutterRecipeContainer.this.resultInventory, 1, -1, -1);
            this.worldPosCallable = worldPosCallable;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player thePlayer, ItemStack stack) {
            stack.m_41678_(thePlayer.f_19853_, thePlayer, stack.m_41613_());
            StonecutterRecipeContainer.this.resultInventory.m_8015_(thePlayer);
            ItemStack itemstack = StonecutterRecipeContainer.this.inputSlot.m_6201_(1);
            if (!itemstack.m_41619_()) {
                StonecutterRecipeContainer.this.updateRecipeResultSlot();
            }
            this.worldPosCallable.m_39292_((world, pos) -> {
                long l = world.m_46467_();
                if (StonecutterRecipeContainer.this.lastOnTake != l) {
                    world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    StonecutterRecipeContainer.this.lastOnTake = l;
                }
            });
            super.m_142406_(thePlayer, stack);
        }
    }
}

