/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.BaseConnectorSettings;
import terrails.xnetgases.helper.ModuleEnums;
import terrails.xnetgases.module.chemical.ChemicalChannelModule;
import terrails.xnetgases.module.chemical.ChemicalEnums;
import terrails.xnetgases.module.chemical.utils.ChemicalHelper;

public class ChemicalConnectorSettings
extends BaseConnectorSettings<ChemicalStack<?>> {
    private ModuleEnums.ConnectorMode connectorMode = ModuleEnums.ConnectorMode.INS;
    private ChemicalEnums.Type connectorType = ChemicalEnums.Type.GAS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer transferRate = null;
    @Nullable
    private Integer minMaxLimit = null;
    private int operationSpeed = 20;
    private boolean transferRateRequired = false;
    private ItemStack filter = ItemStack.f_41583_;

    public ChemicalConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public ModuleEnums.ConnectorMode getConnectorMode() {
        return this.connectorMode;
    }

    public ChemicalEnums.Type getConnectorType() {
        return this.connectorType;
    }

    public int getOperationSpeed() {
        return this.operationSpeed;
    }

    public int getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public boolean isTransferRateRequired() {
        return this.transferRateRequired;
    }

    public int getRate() {
        return Objects.requireNonNullElse(this.transferRate, this.getMaxRate(false));
    }

    private int getMaxRate(boolean advanced) {
        return switch (this.connectorType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalEnums.Type.GAS -> advanced ? (Integer)ChemicalChannelModule.maxGasRateAdvanced.get() : (Integer)ChemicalChannelModule.maxGasRateNormal.get();
            case ChemicalEnums.Type.INFUSE -> advanced ? (Integer)ChemicalChannelModule.maxInfuseRateAdvanced.get() : (Integer)ChemicalChannelModule.maxInfuseRateNormal.get();
            case ChemicalEnums.Type.PIGMENT -> advanced ? (Integer)ChemicalChannelModule.maxPigmentRateAdvanced.get() : (Integer)ChemicalChannelModule.maxPigmentRateNormal.get();
            case ChemicalEnums.Type.SLURRY -> advanced ? (Integer)ChemicalChannelModule.maxSlurryRateAdvanced.get() : (Integer)ChemicalChannelModule.maxSlurryRateNormal.get();
        };
    }

    @Nullable
    public Integer getMinMaxLimit() {
        return this.minMaxLimit;
    }

    @Override
    @Nullable
    public ChemicalStack<?> getMatcher() {
        if (!this.filter.m_41619_()) {
            switch (this.connectorType) {
                case GAS: {
                    if (Capabilities.GAS_HANDLER_CAPABILITY == null || !this.filter.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent()) break;
                    IGasHandler handler = (IGasHandler)this.filter.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IGasHandler Capability doesn't exist!"));
                    return handler.getChemicalInTank(0);
                }
                case INFUSE: {
                    if (Capabilities.INFUSION_HANDLER_CAPABILITY == null || !this.filter.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent()) break;
                    IInfusionHandler handler = (IInfusionHandler)this.filter.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IInfusionHandler Capability doesn't exist!"));
                    return handler.getChemicalInTank(0);
                }
                case PIGMENT: {
                    if (Capabilities.PIGMENT_HANDLER_CAPABILITY == null || !this.filter.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).isPresent()) break;
                    IPigmentHandler handler = (IPigmentHandler)this.filter.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IPigmentHandler Capability doesn't exist!"));
                    return handler.getChemicalInTank(0);
                }
                case SLURRY: {
                    if (Capabilities.SLURRY_HANDLER_CAPABILITY == null || !this.filter.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).isPresent()) break;
                    ISlurryHandler handler = (ISlurryHandler)this.filter.getCapability(Capabilities.SLURRY_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("ISlurryHandler Capability doesn't exist!"));
                    return handler.getChemicalInTank(0);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEnabled(String tag) {
        if (this.connectorMode == ModuleEnums.ConnectorMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return Constants.INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return Constants.EXTRACT_TAGS.contains(tag);
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.connectorMode = ModuleEnums.ConnectorMode.byName((String)data.get("mode"));
        this.connectorType = ChemicalEnums.Type.NAME_MAP.get(((String)data.get("chemical_type")).toUpperCase(Locale.ROOT));
        this.transferRate = (Integer)data.get("transfer_rate");
        this.minMaxLimit = (Integer)data.get("min_max");
        this.transferRateRequired = data.containsKey("rate_required") ? (Boolean)data.get("rate_required") : false;
        this.priority = data.containsKey("priority") ? (Integer)data.get("priority") : null;
        if (data.containsKey("operation_speed")) {
            this.operationSpeed = Integer.parseInt((String)data.get("operation_speed"));
            if (this.operationSpeed == 0) {
                this.operationSpeed = 20;
            }
        } else {
            this.operationSpeed = 20;
        }
        this.filter = ChemicalHelper.normalizeStack((ItemStack)data.get("filter"), this.connectorType);
    }

    @Override
    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        int maxTransferRate = this.getMaxRate(this.advanced);
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices("mode", "Insert or extract mode", (Enum)this.connectorMode, (Enum[])ModuleEnums.ConnectorMode.values()).choices("chemical_type", "Connector type", (Enum)this.connectorType, (Enum[])ChemicalEnums.Type.values());
        if (this.connectorMode == ModuleEnums.ConnectorMode.INS) {
            gui.label("Pri").integer("priority", "Insertion priority", this.priority, 36).shift(5).toggle("rate_required", "Require insert rate", this.transferRateRequired).nl();
        } else {
            gui.choices("operation_speed", "Number of ticks for each operation", Integer.toString(this.operationSpeed), this.advanced ? Constants.CONNECTOR_SPEEDS[0] : Constants.CONNECTOR_SPEEDS[1]).nl();
        }
        gui.label("Rate").integer("transfer_rate", this.connectorMode == ModuleEnums.ConnectorMode.EXT ? "Extraction rate|(max " + maxTransferRate + "mb)" : "Insertion rate|(max " + maxTransferRate + "mb)", this.transferRate, 60, Integer.valueOf(maxTransferRate)).label(this.connectorMode == ModuleEnums.ConnectorMode.EXT ? "Min" : "Max").integer("min_max", this.connectorMode == ModuleEnums.ConnectorMode.EXT ? "Keep this amount in tank" : "Disable insertion if|amount is too high", this.minMaxLimit, 48).nl().label("Filter").ghostSlot("filter", this.filter);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.transferRateRequired = tag.m_128471_("rate_required");
        this.connectorMode = ModuleEnums.ConnectorMode.values()[tag.m_128445_("mode")];
        this.connectorType = ChemicalEnums.Type.values()[tag.m_128445_("chemical_type")];
        this.priority = tag.m_128441_("priority") ? Integer.valueOf(tag.m_128451_("priority")) : null;
        this.transferRate = tag.m_128441_("transfer_rate") ? Integer.valueOf(tag.m_128451_("transfer_rate")) : null;
        this.minMaxLimit = tag.m_128441_("min_max") ? Integer.valueOf(tag.m_128451_("min_max")) : null;
        this.operationSpeed = tag.m_128451_("operation_speed");
        if (this.operationSpeed == 0) {
            this.operationSpeed = 20;
        }
        if (tag.m_128441_("filter")) {
            CompoundTag itemTag = tag.m_128469_("filter");
            this.filter = ChemicalHelper.normalizeStack(ItemStack.m_41712_((CompoundTag)itemTag), this.connectorType);
        } else {
            this.filter = ItemStack.f_41583_;
        }
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128379_("rate_required", this.transferRateRequired);
        tag.m_128344_("mode", (byte)this.connectorMode.ordinal());
        tag.m_128344_("chemical_type", (byte)this.connectorType.ordinal());
        tag.m_128405_("operation_speed", this.operationSpeed);
        if (this.priority != null) {
            tag.m_128405_("priority", this.priority.intValue());
        }
        if (this.transferRate != null) {
            tag.m_128405_("transfer_rate", this.transferRate.intValue());
        }
        if (this.minMaxLimit != null) {
            tag.m_128405_("min_max", this.minMaxLimit.intValue());
        }
        if (!this.filter.m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.filter.m_41739_(itemTag);
            tag.m_128365_("filter", (Tag)itemTag);
        }
    }

    @Override
    public void readFromJson(JsonObject data) {
        super.readFromJsonInternal(data);
        this.connectorMode = (ModuleEnums.ConnectorMode)ChemicalConnectorSettings.getEnumSafe((JsonObject)data, (String)"mode", ModuleEnums.ConnectorMode::byName);
        this.connectorType = (ChemicalEnums.Type)ChemicalConnectorSettings.getEnumSafe((JsonObject)data, (String)"chemical_type", ChemicalEnums.Type.NAME_MAP::get);
        this.priority = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"priority");
        this.transferRate = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"transfer_rate");
        this.transferRateRequired = ChemicalConnectorSettings.getBoolSafe((JsonObject)data, (String)"rate_required");
        this.minMaxLimit = ChemicalConnectorSettings.getIntegerSafe((JsonObject)data, (String)"min_max");
        this.operationSpeed = ChemicalConnectorSettings.getIntegerNotNull((JsonObject)data, (String)"operation_speed");
        if (this.operationSpeed == 0) {
            this.operationSpeed = 20;
        }
        this.filter = data.has("filter") ? ChemicalHelper.normalizeStack(JSonTools.jsonToItemStack((JsonObject)data.get("filter").getAsJsonObject()), this.connectorType) : ItemStack.f_41583_;
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject data = new JsonObject();
        super.writeToJsonInternal(data);
        data.add("rate_required", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.transferRateRequired)));
        ChemicalConnectorSettings.setEnumSafe((JsonObject)data, (String)"mode", (Enum)this.connectorMode);
        ChemicalConnectorSettings.setEnumSafe((JsonObject)data, (String)"chemical_type", (Enum)this.connectorType);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"priority", (Integer)this.priority);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"transfer_rate", (Integer)this.transferRate);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"min_max", (Integer)this.minMaxLimit);
        ChemicalConnectorSettings.setIntegerSafe((JsonObject)data, (String)"operation_speed", (Integer)this.operationSpeed);
        if (!this.filter.m_41619_()) {
            data.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.operationSpeed == 10 || this.transferRate != null && this.transferRate > this.getMaxRate(false)) {
            data.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return data;
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.connectorMode) {
            default -> throw new IncompatibleClassChangeError();
            case ModuleEnums.ConnectorMode.INS -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 70, 13, 10);
            case ModuleEnums.ConnectorMode.EXT -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 13, 70, 13, 10);
        };
    }
}

