/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectable;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integrateddynamics.network.EnergyBatteryNetworkElement;

public class BlockEntityEnergyBattery
extends BlockEntityCableConnectable
implements IEnergyStorageCapacity {
    @NBTPersist
    private int energy;
    @NBTPersist(useDefaultValue=false)
    private int capacity = BlockEnergyBatteryConfig.capacity;

    public BlockEntityEnergyBattery(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_ENERGY_BATTERY, blockPos, blockState);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new EnergyBatteryNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
        this.addCapabilityInternal(CapabilityEnergy.ENERGY, LazyOptional.of(() -> this));
    }

    public boolean isCreative() {
        Block block = this.m_58900_().m_60734_();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public int getEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    protected void setEnergy(int energy) {
        int lastEnergy;
        if (!this.isCreative() && (lastEnergy = this.energy) != energy) {
            this.energy = energy;
            this.m_6596_();
            this.sendUpdate();
        }
    }

    public int getUpdateBackoffTicks() {
        return 20;
    }

    public void onUpdateReceived() {
        super.onUpdateReceived();
    }

    public static int getEnergyPerTick(int capacity) {
        return Math.max(capacity / BlockEnergyBatteryConfig.energyRateCapacityFraction, BlockEnergyBatteryConfig.minEnergyRate);
    }

    protected int getEnergyPerTick() {
        return BlockEntityEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (!this.isCreative()) {
            int stored = this.getEnergyStored();
            int energyReceived = Math.min(this.getMaxEnergyStored() - stored, energy);
            if (!simulate) {
                this.setEnergy(stored + energyReceived);
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        energy = Math.max(0, Math.min(energy, this.getEnergyPerTick()));
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(newEnergy);
        }
        return stored - newEnergy;
    }

    protected int addEnergy(int energy) {
        int filled = this.addEnergyFe(energy, false);
        this.extractEnergy(filled, false);
        return filled;
    }

    protected int addEnergyFe(int energy, boolean simulate) {
        return EnergyHelpers.fillNeigbours(this.m_58904_(), this.m_58899_(), energy, simulate);
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public static class Ticker
    extends BlockEntityCableConnectable.Ticker<BlockEntityEnergyBattery> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEnergyBattery blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.getEnergyStored() > 0 && level.m_46753_(pos)) {
                blockEntity.addEnergy(Math.min(blockEntity.getEnergyPerTick(), blockEntity.getEnergyStored()));
            }
        }

        protected void onSendUpdate(Level level, BlockPos pos) {
            BlockState blockState = level.m_8055_(pos);
            level.m_7260_(pos, blockState, blockState, 7);
        }
    }
}

