/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderConfig;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.inventory.container.ContainerVariablestore;
import org.cyclops.integrateddynamics.network.VariablestoreNetworkElement;

public class BlockEntityVariablestore
extends BlockEntityCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<VariablestoreNetworkElement>,
MenuProvider {
    public static final int ROWS = 5;
    public static final int COLS = 9;
    public static final int INVENTORY_SIZE = 45;
    private final IVariableContainer variableContainer;
    private boolean shouldSendUpdateEvent = false;

    public BlockEntityVariablestore(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_VARIABLE_STORE, blockPos, blockState, 45, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, LazyOptional.of(() -> this.getInventory().getItemHandler()));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new VariablestoreNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
        this.variableContainer = new VariableContainerDefault();
        this.addCapabilityInternal(VariableContainerConfig.CAPABILITY, LazyOptional.of(() -> this.variableContainer));
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int slot, ItemStack itemStack) {
                return super.m_7013_(slot, itemStack) && (itemStack.m_41619_() || itemStack.getCapability(VariableFacadeHolderConfig.CAPABILITY, null).isPresent());
            }
        };
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        this.shouldSendUpdateEvent = true;
    }

    protected void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.variableContainer.refreshVariables(this.getNetwork(), (Container)this.getInventory(), sendVariablesUpdateEvent);
    }

    public void onDirty() {
        if (!this.f_58857_.m_5776_()) {
            this.refreshVariables(true);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldSendUpdateEvent = true;
        }
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, VariablestoreNetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables(false);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerVariablestore(id, playerInventory, (Container)this.getInventory());
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.integrateddynamics.variablestore");
    }

    public static class Ticker
    extends BlockEntityCableConnectableInventory.Ticker<BlockEntityVariablestore> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityVariablestore blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.shouldSendUpdateEvent && blockEntity.getNetwork() != null) {
                blockEntity.shouldSendUpdateEvent = false;
                blockEntity.refreshVariables(true);
            }
        }
    }
}

