/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableMultipartTicking;
import org.cyclops.integrateddynamics.capability.cable.CableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableDefault;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderPartContainer;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTileMultipartTicking;
import org.cyclops.integrateddynamics.client.model.CableRenderState;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class BlockEntityMultipartTicking
extends CyclopsBlockEntity
implements PartHelpers.IPartStateHolderCallback {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> redstoneLevels = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneInputs = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneStrong = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lastRedstonePulses = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lightLevels = EnumFacingMap.newMap();
    private EnumFacingMap<Integer> previousLightLevels;
    @NBTPersist
    private CompoundTag facadeBlockTag = null;
    private final PartContainerTileMultipartTicking partContainer = new PartContainerTileMultipartTicking(this);
    private final CableTileMultipartTicking cable;
    private final INetworkCarrier networkCarrier;
    private final ICableFakeable cableFakeable;
    @NBTPersist
    private boolean forceLightCheckAtClient;
    private IModelData cachedState = null;

    public BlockEntityMultipartTicking(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_MULTIPART_TICKING, blockPos, blockState);
        this.addCapabilityInternal(PartContainerConfig.CAPABILITY, LazyOptional.of(() -> this.partContainer));
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderPartContainer(this.partContainer)));
        this.addCapabilityInternal(FacadeableConfig.CAPABILITY, LazyOptional.of(() -> new FacadeableTileMultipartTicking(this)));
        this.cable = new CableTileMultipartTicking(this);
        this.addCapabilityInternal(CableConfig.CAPABILITY, LazyOptional.of(() -> this.cable));
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, LazyOptional.of(() -> this.networkCarrier));
        this.cableFakeable = new CableFakeableMultipartTicking(this);
        this.addCapabilityInternal(CableFakeableConfig.CAPABILITY, LazyOptional.of(() -> this.cableFakeable));
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, LazyOptional.of(() -> new PathElementTileMultipartTicking(this, (ICable)this.cable)));
        for (Direction facing : Direction.values()) {
            this.addCapabilitySided(DynamicLightConfig.CAPABILITY, facing, LazyOptional.of(() -> new DynamicLightTileMultipartTicking(this, facing)));
            this.addCapabilitySided(DynamicRedstoneConfig.CAPABILITY, facing, LazyOptional.of(() -> new DynamicRedstoneTileMultipartTicking(this, facing)));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.forceLightCheckAtClient = false;
        tag.m_128365_("partContainer", (Tag)this.partContainer.serializeNBT());
        tag.m_128379_("realCable", this.cableFakeable.isRealCable());
    }

    public void read(CompoundTag tag) {
        boolean isLightTransparent;
        EnumFacingMap lastConnected = EnumFacingMap.newMap(this.connected);
        CompoundTag lastFacadeBlock = this.facadeBlockTag;
        boolean lastRealCable = this.cableFakeable.isRealCable();
        this.partContainer.deserializeNBT(tag.m_128469_("partContainer"));
        boolean wasLightTransparent = this.m_58904_() != null && CableHelpers.isLightTransparent((BlockGetter)this.m_58904_(), this.m_58899_(), null);
        super.read(tag);
        this.cableFakeable.setRealCable(tag.m_128471_("realCable"));
        boolean bl = isLightTransparent = this.m_58904_() != null && CableHelpers.isLightTransparent((BlockGetter)this.m_58904_(), this.m_58899_(), null);
        if (!(this.m_58904_() == null || lastConnected != null && this.connected != null && lastConnected.equals(this.connected) && Objects.equals(lastFacadeBlock, this.facadeBlockTag) && lastRealCable == this.cableFakeable.isRealCable() && wasLightTransparent == isLightTransparent)) {
            BlockHelpers.markForUpdate((Level)this.m_58904_(), (BlockPos)this.m_58899_());
        }
    }

    public void onUpdateReceived() {
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
        }
        this.cachedState = null;
        BlockHelpers.markForUpdate((Level)this.m_58904_(), (BlockPos)this.m_58899_());
        if (this.forceLightCheckAtClient) {
            this.m_58904_().m_5518_().m_142202_(this.m_58899_());
        }
    }

    public IModelData getConnectionState() {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        if (this.partContainer.getPartData() != null) {
            builder.withInitial(BlockCable.REALCABLE, (Object)this.cableFakeable.isRealCable());
            if (this.connected.isEmpty()) {
                this.getCable().updateConnections();
            }
            for (Direction side : Direction.values()) {
                builder.withInitial(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.cable.isForceDisconnected(side) && (Boolean)this.connected.get((Object)side) != false ? 1 : 0));
                builder.withInitial(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.partContainer.hasPart(side) ? this.partContainer.getPart(side).getPartRenderPosition() : PartRenderPosition.NONE));
            }
            IFacadeable facadeable = (IFacadeable)this.getCapability(FacadeableConfig.CAPABILITY).orElseGet(FacadeableDefault::new);
            builder.withInitial(BlockCable.FACADE, facadeable.hasFacade() ? Optional.of(facadeable.getFacade()) : Optional.empty());
            builder.withInitial(BlockCable.PARTCONTAINER, (Object)this.partContainer);
            builder.withInitial(BlockCable.RENDERSTATE, (Object)new CableRenderState(this.cableFakeable.isRealCable(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap(this.connected), EnumFacingMap.newMap(this.partContainer.getPartData()), (Tag)this.facadeBlockTag));
        }
        this.cachedState = builder.build();
        return this.cachedState;
    }

    public void updateRedstoneInfo(Direction side, boolean strongPower) {
        this.m_6596_();
        if (this.m_58904_().m_46749_(this.m_58899_().m_142300_(side))) {
            this.m_58904_().m_46586_(this.m_58899_().m_142300_(side), this.m_58900_().m_60734_(), this.m_58899_());
            if (strongPower) {
                this.m_58904_().m_46672_(this.m_58899_().m_142300_(side), this.m_58900_().m_60734_());
            }
        }
    }

    public void updateLightInfo() {
        this.sendUpdate();
    }

    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(EnumFacingMap<Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        LazyOptional value = super.getCapability(capability, facing);
        if (value.isPresent()) {
            return value;
        }
        return this.partContainer.getCapability(capability, facing);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.invalidateParts();
    }

    protected void invalidateParts() {
        INetwork network;
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && (network = this.getNetwork()) != null) {
            for (Map.Entry entry : this.partContainer.getPartData().entrySet()) {
                INetworkElement element = ((PartHelpers.PartStateHolder)entry.getValue()).getPart().createNetworkElement(this.getPartContainer(), DimPos.of((Level)this.m_58904_(), (BlockPos)this.m_58899_()), (Direction)entry.getKey());
                element.invalidate(network);
            }
        }
    }

    protected Direction transformFacingForRotation(Direction facing) {
        return facing;
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public EnumFacingMap<Integer> getRedstoneLevels() {
        return this.redstoneLevels;
    }

    public EnumFacingMap<Boolean> getRedstoneInputs() {
        return this.redstoneInputs;
    }

    public EnumFacingMap<Boolean> getRedstoneStrong() {
        return this.redstoneStrong;
    }

    public EnumFacingMap<Integer> getLastRedstonePulses() {
        return this.lastRedstonePulses;
    }

    public EnumFacingMap<Integer> getLightLevels() {
        return this.lightLevels;
    }

    public CompoundTag getFacadeBlockTag() {
        return this.facadeBlockTag;
    }

    public void setFacadeBlockTag(CompoundTag facadeBlockTag) {
        this.facadeBlockTag = facadeBlockTag;
    }

    public PartContainerTileMultipartTicking getPartContainer() {
        return this.partContainer;
    }

    public CableTileMultipartTicking getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public ICableFakeable getCableFakeable() {
        return this.cableFakeable;
    }

    public void setForceLightCheckAtClient(boolean forceLightCheckAtClient) {
        this.forceLightCheckAtClient = forceLightCheckAtClient;
    }

    public static class Ticker<T extends BlockEntityMultipartTicking>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityMultipartTicking)blockEntity).getConnected().isEmpty()) {
                ((BlockEntityMultipartTicking)blockEntity).getCable().updateConnections();
            }
            ((BlockEntityMultipartTicking)blockEntity).getPartContainer().update();
            if (((BlockEntityMultipartTicking)blockEntity).getNetwork() == null) {
                NetworkHelpers.revalidateNetworkElements(level, pos);
            }
        }
    }
}

