/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class CableHelpers {
    public static final Collection<Direction> ALL_SIDES = Sets.newIdentityHashSet();
    private static boolean removingCable;

    public static LazyOptional<ICable> getCable(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, CableConfig.CAPABILITY);
    }

    public static LazyOptional<ICableFakeable> getCableFakeable(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, CableFakeableConfig.CAPABILITY);
    }

    public static LazyOptional<IPathElement> getPathElement(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY);
    }

    public static void updateConnectionsNeighbours(BlockGetter world, BlockPos pos, Collection<Direction> sides) {
        for (Direction side : sides) {
            CableHelpers.updateConnections(world, pos.m_142300_(side), side.m_122424_());
        }
    }

    public static void updateConnections(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        CableHelpers.getCable(world, pos, side).ifPresent(ICable::updateConnections);
    }

    public static boolean isCableConnected(BlockGetter world, BlockPos pos, Direction side) {
        return CableHelpers.getCable(world, pos, side).map(cable -> cable.isConnected(side)).orElse(false);
    }

    public static boolean canCableConnectTo(BlockGetter world, BlockPos pos, Direction side, ICable originCable) {
        BlockPos neighbourPos = pos.m_142300_(side);
        return CableHelpers.getCable(world, neighbourPos, side.m_122424_()).map(neighbourCable -> originCable.canConnect((ICable)neighbourCable, side) && neighbourCable.canConnect(originCable, side.m_122424_())).orElse(false);
    }

    public static boolean isNoFakeCable(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return CableHelpers.getCableFakeable(world, pos, side).map(ICableFakeable::isRealCable).orElse(true);
    }

    public static void disconnectCable(Level world, BlockPos pos, Direction side, ICable cable, Direction disconnectSide) {
        cable.disconnect(disconnectSide);
        cable.updateConnections();
        Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
        sidesToUpdate.add(disconnectSide);
        CableHelpers.updateConnectionsNeighbours((BlockGetter)world, pos, sidesToUpdate);
        NetworkHelpers.initNetwork(world, pos, side);
        NetworkHelpers.initNetwork(world, pos.m_142300_(disconnectSide), side.m_122424_());
    }

    public static InteractionResult onCableActivated(Level world, BlockPos pos, BlockState state, Player player, ItemStack heldItem, Direction side, @Nullable Direction cableConnectionHit) {
        ICable cable = (ICable)CableHelpers.getCable((BlockGetter)world, pos, side).orElse(null);
        if (cable == null) {
            return InteractionResult.PASS;
        }
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            BlockPos neighbourPos;
            ICable neighbourCable;
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_36341_()) {
                CableHelpers.removeCable(world, pos, player);
            } else if (cableConnectionHit != null) {
                CableHelpers.disconnectCable(world, pos, side, cable, cableConnectionHit);
            } else if (cableConnectionHit == null && (neighbourCable = (ICable)CableHelpers.getCable((BlockGetter)world, neighbourPos = pos.m_142300_(side), side.m_122424_()).orElse(null)) != null && !cable.isConnected(side) && (cable.canConnect(neighbourCable, side) || neighbourCable.canConnect(cable, side.m_122424_()))) {
                cable.reconnect(side);
                neighbourCable.reconnect(side.m_122424_());
                cable.updateConnections();
                Collection<Direction> sidesToUpdate = CableHelpers.getCableConnections(cable);
                sidesToUpdate.add(side);
                CableHelpers.updateConnectionsNeighbours((BlockGetter)world, pos, sidesToUpdate);
                NetworkHelpers.initNetwork(world, pos, side);
                NetworkHelpers.initNetwork(world, neighbourPos, side.m_122424_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onCableAdded(Level world, BlockPos pos) {
        CableHelpers.updateConnectionsNeighbours((BlockGetter)world, pos, ALL_SIDES);
        if (!world.m_5776_()) {
            NetworkHelpers.initNetwork(world, pos, null).ifPresent(network -> MinecraftForge.EVENT_BUS.post((Event)new NetworkInitializedEvent((INetwork)network, world, pos, null)));
        }
    }

    public static void onCableAddedByPlayer(Level world, BlockPos pos, @Nullable LivingEntity placer) {
        CableHelpers.updateConnectionsNeighbours((BlockGetter)world, pos, ALL_SIDES);
        if (!world.m_5776_()) {
            NetworkHelpers.initNetwork(world, pos, null).ifPresent(network -> MinecraftForge.EVENT_BUS.post((Event)new NetworkInitializedEvent((INetwork)network, world, pos, placer)));
        }
    }

    public static boolean onCableRemoving(Level world, BlockPos pos, boolean dropMainElement, boolean saveState) {
        if (!world.m_5776_() && CableHelpers.isNoFakeCable((BlockGetter)world, pos, null)) {
            INetworkCarrier networkCarrier = (INetworkCarrier)NetworkHelpers.getNetworkCarrier((BlockGetter)world, pos, null).orElse(null);
            LinkedList itemStacks = Lists.newLinkedList();
            INetworkElementProvider networkElementProvider = (INetworkElementProvider)NetworkHelpers.getNetworkElementProvider((BlockGetter)world, pos, null).orElse(null);
            if (networkElementProvider != null) {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.addDrops(itemStacks, dropMainElement, saveState);
                }
                for (ItemStack itemStack : itemStacks) {
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
            if (networkCarrier != null && networkCarrier.getNetwork() != null) {
                IPathElement pathElement = (IPathElement)CableHelpers.getPathElement((BlockGetter)world, pos, null).orElseThrow(() -> new IllegalStateException("Could not find a valid path element capability"));
                INetwork network = networkCarrier.getNetwork();
                networkCarrier.setNetwork(null);
                return network.removePathElement(pathElement, null);
            }
        }
        return true;
    }

    public static boolean onCableRemoved(Level world, BlockPos pos, Collection<Direction> sides) {
        CableHelpers.updateConnectionsNeighbours((BlockGetter)world, pos, sides);
        if (!world.m_5776_()) {
            for (Direction side : sides) {
                BlockPos sidePos = pos.m_142300_(side);
                NetworkHelpers.initNetwork(world, sidePos, side.m_122424_());
            }
        }
        return true;
    }

    public static boolean isRemovingCable() {
        return removingCable;
    }

    public static void setRemovingCable(boolean removingCable) {
        CableHelpers.removingCable = removingCable;
    }

    public static void removeCable(Level world, BlockPos pos, @Nullable Player player) {
        removingCable = true;
        ICable cable = (ICable)CableHelpers.getCable((BlockGetter)world, pos, null).orElse(null);
        ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((BlockGetter)world, pos, null).orElse(null);
        IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer((BlockGetter)world, pos, null).orElse(null);
        BlockState blockState = world.m_8055_(pos);
        if (cable == null) {
            removingCable = false;
            return;
        }
        Collection<Direction> connectedCables = CableHelpers.getCableConnections(cable);
        CableHelpers.onCableRemoving(world, pos, false, false);
        if (cableFakeable == null || partContainer == null || !partContainer.hasParts()) {
            cable.destroy();
        } else {
            cableFakeable.setRealCable(false);
        }
        if (player == null) {
            ItemStackHelpers.spawnItemStack((Level)world, (BlockPos)pos, (ItemStack)cable.getItemStack());
        } else if (!player.m_7500_()) {
            ItemStackHelpers.spawnItemStackToPlayer((Level)world, (BlockPos)pos, (ItemStack)cable.getItemStack(), (Player)player);
        }
        CableHelpers.onCableRemoved(world, pos, connectedCables);
        ItemBlockCable.playBreakSound(world, pos, blockState);
        removingCable = false;
    }

    public static boolean hasFacade(BlockGetter world, BlockPos pos) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY).map(IFacadeable::hasFacade).orElse(false);
    }

    public static Optional<BlockState> getFacade(BlockGetter world, BlockPos pos) {
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY).resolve().flatMap(facadeable -> Optional.ofNullable(facadeable.getFacade()));
    }

    public static boolean isLightTransparent(BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return PartHelpers.getPartContainer(world, pos, side).map(partContainer -> {
            for (Map.Entry<Direction, IPartType<?, ?>> entry : partContainer.getParts().entrySet()) {
                IPartType<?, ?> part = entry.getValue();
                if (!part.forceLightTransparency(partContainer.getPartState(entry.getKey()))) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static Collection<Direction> getCableConnections(ICable cable) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!cable.isConnected(side)) continue;
            sides.add(side);
        }
        return sides;
    }

    public static Collection<Direction> getExternallyConnectedCables(Level world, BlockPos pos) {
        Set sides = Sets.newIdentityHashSet();
        for (Direction side : Direction.values()) {
            if (!CableHelpers.isCableConnected((BlockGetter)world, pos.m_142300_(side), side.m_122424_())) continue;
            sides.add(side);
        }
        return sides;
    }

    static {
        for (Direction side : Direction.values()) {
            ALL_SIDES.add(side);
        }
        removingCable = false;
    }
}

