/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiBox;

@OnlyIn(value=Dist.CLIENT)
public class RenderPattern<E extends IGuiInputElement, G extends GuiComponent, C extends AbstractContainerMenu>
extends SubGuiBox
implements ISubGuiBox {
    protected final E element;
    private final int x;
    private final int y;
    protected final G gui;
    protected final C container;

    public RenderPattern(E element, int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        super(SubGuiBox.Box.LIGHT);
        this.element = element;
        IConfigRenderPattern configRenderPattern = element.getRenderPattern();
        this.x = RenderPattern.calculateX(baseX, maxWidth, configRenderPattern);
        this.y = RenderPattern.calculateY(baseY, maxHeight, configRenderPattern);
        this.gui = gui;
        this.container = container;
    }

    public static int calculateX(int baseX, int maxWidth, IConfigRenderPattern configRenderPattern) {
        return baseX + (maxWidth - configRenderPattern.getWidth()) / 2;
    }

    public static int calculateY(int baseY, int maxHeight, IConfigRenderPattern configRenderPattern) {
        return baseY + (maxHeight - configRenderPattern.getHeight()) / 2;
    }

    protected void drawSlot(PoseStack matrixStack, int x, int y) {
        this.m_93228_(matrixStack, x, y, 19, 0, 18, 18);
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
    }

    @Override
    public void tick() {
    }

    protected boolean drawRenderPattern() {
        return true;
    }

    @Override
    public void renderBg(PoseStack matrixStack, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(matrixStack, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        if (this.drawRenderPattern()) {
            IConfigRenderPattern configRenderPattern = this.element.getRenderPattern();
            int baseX = this.getX() + guiLeft;
            int baseY = this.getY() + guiTop;
            for (Pair<Integer, Integer> slot : configRenderPattern.getSlotPositions()) {
                this.drawSlot(matrixStack, baseX + (Integer)slot.getLeft(), baseY + (Integer)slot.getRight());
            }
            if (configRenderPattern.getSymbolPosition() != null) {
                RenderHelpers.drawScaledCenteredString((PoseStack)matrixStack, (Font)fontRenderer, (String)this.element.getSymbol(), (int)(baseX + (Integer)configRenderPattern.getSymbolPosition().getLeft()), (int)(baseY + (Integer)configRenderPattern.getSymbolPosition().getRight() + 8), (int)0, (float)1.0f, (int)0);
            }
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.element.getRenderPattern().getWidth();
    }

    @Override
    public int getHeight() {
        return this.element.getRenderPattern().getHeight();
    }

    public E getElement() {
        return this.element;
    }
}

