/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRegistry;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public final class AspectRegistry
implements IAspectRegistry {
    private static AspectRegistry INSTANCE = new AspectRegistry();
    private static final IAspectVariableFacade INVALID_FACADE = new AspectVariableFacade(false, -1, null);
    private final Map<IPartType, Set<IAspect>> partAspects = new IdentityHashMap<IPartType, Set<IAspect>>();
    private final Map<IPartType, Set<IAspectRead>> partReadAspects = new IdentityHashMap<IPartType, Set<IAspectRead>>();
    private final Map<IPartType, Set<IAspectWrite>> partWriteAspects = new IdentityHashMap<IPartType, Set<IAspectWrite>>();
    private final Map<IPartType, List<IAspectRead>> partReadAspectsListTransform = new IdentityHashMap<IPartType, List<IAspectRead>>();
    private final Map<IPartType, List<IAspectWrite>> partWriteAspectsListTransform = new IdentityHashMap<IPartType, List<IAspectWrite>>();
    private final Map<String, IAspect> unlocalizedAspects = Maps.newHashMap();
    private final Map<String, IAspectRead> unlocalizedReadAspects = Maps.newHashMap();
    private final Map<String, IAspectWrite> unlocalizedWriteAspects = Maps.newHashMap();
    @OnlyIn(value=Dist.CLIENT)
    private Map<IAspect, ResourceLocation> aspectModels;

    private AspectRegistry() {
        ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        if (MinecraftHelpers.isClientSide()) {
            this.aspectModels = new IdentityHashMap<IAspect, ResourceLocation>();
        }
    }

    public static AspectRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public IAspect register(IPartType partType, IAspect aspect) {
        this.registerSubAspectType(partType, aspect, this.partAspects, this.unlocalizedAspects);
        if (aspect instanceof IAspectRead) {
            this.registerSubAspectType(partType, (IAspectRead)aspect, this.partReadAspects, this.unlocalizedReadAspects);
            this.partReadAspectsListTransform.put(partType, Lists.newArrayList((Iterable)this.partReadAspects.get(partType)));
        }
        if (aspect instanceof IAspectWrite) {
            this.registerSubAspectType(partType, (IAspectWrite)aspect, this.partWriteAspects, this.unlocalizedWriteAspects);
            this.partWriteAspectsListTransform.put(partType, Lists.newArrayList((Iterable)this.partWriteAspects.get(partType)));
        }
        return aspect;
    }

    protected <T extends IAspect> void registerSubAspectType(IPartType partType, T aspect, Map<IPartType, Set<T>> partAspects, Map<String, T> unlocalizedAspects) {
        LinkedHashSet aspects = partAspects.get(partType);
        if (aspects == null) {
            aspects = Sets.newLinkedHashSet();
            partAspects.put(partType, aspects);
        }
        aspects.add(aspect);
        unlocalizedAspects.put(aspect.getUniqueName().toString(), aspect);
    }

    @Override
    public void register(IPartType partType, Collection<IAspect> aspects) {
        for (IAspect aspect : aspects) {
            this.register(partType, aspect);
        }
    }

    @Override
    public Set<IAspect> getAspects(IPartType partType) {
        Set<IAspect> aspects = this.partAspects.get(partType);
        if (aspects == null) {
            return Collections.unmodifiableSet(Collections.emptySet());
        }
        return Collections.unmodifiableSet(aspects);
    }

    @Override
    public List<IAspectRead> getReadAspects(IPartType partType) {
        List<IAspectRead> aspects = this.partReadAspectsListTransform.get(partType);
        if (aspects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(aspects);
    }

    @Override
    public List<IAspectWrite> getWriteAspects(IPartType partType) {
        List<IAspectWrite> aspects = this.partWriteAspectsListTransform.get(partType);
        if (aspects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(aspects);
    }

    @Override
    public Set<IAspect> getAspects() {
        return ImmutableSet.copyOf(this.unlocalizedAspects.values());
    }

    @Override
    public Set<IAspectRead> getReadAspects() {
        return ImmutableSet.copyOf(this.unlocalizedReadAspects.values());
    }

    @Override
    public Set<IAspectWrite> getWriteAspects() {
        return ImmutableSet.copyOf(this.unlocalizedWriteAspects.values());
    }

    @Override
    public IAspect getAspect(ResourceLocation name) {
        return this.unlocalizedAspects.get(name.toString());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerAspectModel(IAspect aspect, ResourceLocation modelLocation) {
        this.aspectModels.put(aspect, modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getAspectModel(IAspect aspect) {
        return this.aspectModels.get(aspect);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Collection<ResourceLocation> getAspectModels() {
        return Collections.unmodifiableCollection(this.aspectModels.values());
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integrateddynamics", "aspect");
    }

    @Override
    public IAspectVariableFacade getVariableFacade(int id, CompoundTag tag) {
        if (!tag.m_128425_("partId", 3) || !tag.m_128425_("aspectName", 8)) {
            return INVALID_FACADE;
        }
        int partId = tag.m_128451_("partId");
        IAspect aspect = this.getAspect(new ResourceLocation(tag.m_128461_("aspectName")));
        if (aspect == null) {
            return INVALID_FACADE;
        }
        return new AspectVariableFacade(id, partId, aspect);
    }

    @Override
    public void setVariableFacade(CompoundTag tag, IAspectVariableFacade variableFacade) {
        tag.m_128405_("partId", variableFacade.getPartId());
        tag.m_128359_("aspectName", variableFacade.getAspect().getUniqueName().toString());
    }

    @Override
    public VariablePredicate deserializeVariablePredicate(JsonObject element, @Nullable IValueType valueType, ValuePredicate valuePredicate) {
        JsonElement aspectElement = element.get("aspect");
        IAspect aspect = null;
        if (aspectElement != null && !aspectElement.isJsonNull() && (aspect = Aspects.REGISTRY.getAspect(new ResourceLocation(GsonHelper.m_13906_((JsonObject)element, (String)"aspect")))) == null) {
            throw new JsonSyntaxException("Unknown aspect type '" + GsonHelper.m_13906_((JsonObject)element, (String)"aspect") + "', valid types are: " + Aspects.REGISTRY.getAspects().stream().map(IAspect::getUniqueName).collect(Collectors.toList()));
        }
        return new AspectVariablePredicate(valueType, valuePredicate, aspect);
    }

    @Override
    public VariableFacadePredicate deserializeVariableFacadePredicate(JsonObject element) {
        return null;
    }

    public static class AspectVariablePredicate
    extends VariablePredicate<IAspectVariable> {
        private final IAspect aspect;

        public AspectVariablePredicate(@Nullable IValueType valueType, ValuePredicate valuePredicate, @Nullable IAspect aspect) {
            super(IAspectVariable.class, valueType, valuePredicate);
            this.aspect = aspect;
        }

        @Override
        protected boolean testTyped(IAspectVariable variable) {
            return super.testTyped(variable) && (this.aspect == null || variable.getAspect() == this.aspect);
        }
    }

    public static class AspectVariableFacadePredicate
    extends VariableFacadePredicate<IAspectVariableFacade> {
        private final IAspect aspect;

        public AspectVariableFacadePredicate(@Nullable IAspect aspect) {
            super(IAspectVariableFacade.class);
            this.aspect = aspect;
        }

        @Override
        protected boolean testTyped(IAspectVariableFacade variableFacade) {
            return super.testTyped(variableFacade) && (this.aspect == null || variableFacade.getAspect() == this.aspect);
        }
    }
}

