/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.aspect;

import lombok.NonNull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.expression.VariableAdapter;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;

public abstract class LazyAspectVariable<V extends IValue>
extends VariableAdapter<V>
implements IAspectVariable<V> {
    private final IValueType<V> type;
    private final PartTarget target;
    private final IAspectRead<V, ?> aspect;
    @NonNull
    private V value;
    private IAspectProperties cachedProperties = null;
    private boolean isGettingValue = false;

    public LazyAspectVariable(IValueType<V> type, PartTarget target, IAspectRead<V, ?> aspect) {
        this.type = type;
        this.target = target;
        this.aspect = aspect;
    }

    @Override
    public void invalidate() {
        if (this.value != null) {
            this.value = null;
            this.cachedProperties = null;
            super.invalidate();
        }
    }

    @Override
    public V getValue() throws EvaluationException {
        if (this.value == null) {
            if (this.isGettingValue) {
                throw new EvaluationException((MutableComponent)new TranslatableComponent("variable.integrateddynamics.error.recursion", new Object[]{new TranslatableComponent(this.getAspect().getTranslationKey())}));
            }
            this.isGettingValue = true;
            try {
                this.value = this.getValueLazy();
            }
            catch (EvaluationException e) {
                this.isGettingValue = false;
                throw e;
            }
            this.isGettingValue = false;
        }
        return this.value;
    }

    protected IAspectProperties getAspectProperties() {
        PartPos pos;
        Pair<IPartType, IPartState> partData;
        if (this.cachedProperties == null && this.getAspect().hasProperties() && (partData = PartPos.getPartData(pos = this.getTarget().getCenter())) != null) {
            this.cachedProperties = this.getAspect().getProperties((IPartType)partData.getLeft(), this.getTarget(), (IPartState)partData.getRight());
        }
        return this.cachedProperties;
    }

    public abstract V getValueLazy() throws EvaluationException;

    @Override
    public IValueType<V> getType() {
        return this.type;
    }

    @Override
    public PartTarget getTarget() {
        return this.target;
    }

    @Override
    public IAspectRead<V, ?> getAspect() {
        return this.aspect;
    }
}

