/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.write;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeAspects;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.event.PartWriterAspectEvent;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartWriter;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartTypeWriteBase<P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>>
extends PartTypeAspects<P, S>
implements IPartTypeWriter<P, S> {
    private List<IAspectWrite> aspectsWrite = null;

    public PartTypeWriteBase(String name) {
        this(name, new PartRenderPosition(0.3125f, 0.3125f, 0.625f, 0.625f, 0.25f, 0.25f));
    }

    public PartTypeWriteBase(String name, PartRenderPosition partRenderPosition) {
        super(name, partRenderPosition);
    }

    @Override
    protected Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> constructNetworkEventActions() {
        Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> actions = super.constructNetworkEventActions();
        PartTypeBase.IEventAction updateEventListener = (network, target, state, event) -> NetworkHelpers.getPartNetwork(network).ifPresent(partNetwork -> this.onVariableContentsUpdated((IPartNetwork)partNetwork, target, (S)state));
        actions.put(VariableContentsUpdatedEvent.class, updateEventListener);
        actions.put(NetworkElementAddEvent.Post.class, updateEventListener);
        return actions;
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus();
    }

    @Override
    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.update(network, partNetwork, target, state);
        IAspectWrite aspect = this.getActiveAspect(target, state);
        if (aspect != null) {
            aspect.update(network, partNetwork, this, target, state);
        }
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (int i = 0; i < state.getInventory().m_6643_(); ++i) {
            ItemStack itemStack = state.getInventory().m_8020_(i);
            if (itemStack.m_41619_()) continue;
            itemStacks.add(itemStack);
        }
        state.getInventory().m_6211_();
        state.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, null);
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
    }

    @Override
    public void beforeNetworkKill(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.beforeNetworkKill(network, partNetwork, target, state);
        state.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, null);
    }

    @Override
    public void afterNetworkAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkAlive(network, partNetwork, target, state);
        this.updateActivation(target, state, null);
    }

    @Override
    public List<IAspectWrite> getWriteAspects() {
        if (this.aspectsWrite == null) {
            this.aspectsWrite = Aspects.REGISTRY.getWriteAspects(this);
        }
        return this.aspectsWrite;
    }

    @Override
    public boolean hasActiveVariable(IPartNetwork network, PartTarget target, S partState) {
        return partState.hasVariable();
    }

    @Override
    public <V extends IValue> IVariable<V> getActiveVariable(INetwork network, IPartNetwork partNetwork, PartTarget target, S partState) {
        return partState.getVariable(network, partNetwork);
    }

    @Override
    public IAspectWrite getActiveAspect(PartTarget target, S partState) {
        return partState.getActiveAspect();
    }

    @Override
    public void updateActivation(PartTarget target, S partState, @Nullable Player player) {
        IPartNetwork partNetwork;
        int activeIndex = -1;
        for (int i = 0; i < partState.getInventory().m_6643_(); ++i) {
            if (partState.getInventory().m_8020_(i).m_41619_()) continue;
            activeIndex = i;
            break;
        }
        IAspectWrite aspect = activeIndex == -1 ? null : this.getWriteAspects().get(activeIndex);
        partState.triggerAspectInfoUpdate((PartTypeWriteBase)this, target, aspect);
        INetwork network = (INetwork)NetworkHelpers.getNetwork(target.getCenter()).orElse(null);
        if (network != null && aspect != null && (partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork(network).orElse(null)) != null) {
            MinecraftForge.EVENT_BUS.post(new PartWriterAspectEvent<PartTypeWriteBase, S, IAspectWrite>(network, partNetwork, target, this, partState, player, aspect, partState.getInventory().m_8020_(activeIndex)));
        }
        if (network != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        state.onVariableContentsUpdated((PartTypeWriteBase)this, target);
    }

    protected IgnoredBlockStatus.Status getStatus(IPartStateWriter state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null && !state.getInventory().m_7983_()) {
            status = state.hasVariable() && state.isEnabled() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (IPartStateWriter)partContainer.getPartState(side) : null);
        return (BlockState)((BlockState)this.getBlock().m_49966_().m_61124_((Property)IgnoredBlock.FACING, (Comparable)side)).m_61124_((Property)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    @Override
    public void loadTooltip(S state, List<Component> lines) {
        super.loadTooltip(state, lines);
        IAspectWrite aspectWrite = state.getActiveAspect();
        if (aspectWrite != null) {
            if (state.hasVariable() && state.isEnabled()) {
                lines.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.writer.active_aspect", new Object[]{new TranslatableComponent(aspectWrite.getTranslationKey()), new TranslatableComponent(aspectWrite.getValueType().getTranslationKey()).m_130940_(aspectWrite.getValueType().getDisplayColorFormat())}));
            } else {
                lines.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.errors").m_130940_(ChatFormatting.RED));
                for (MutableComponent error : state.getErrors(aspectWrite)) {
                    lines.add((Component)error.m_130940_(ChatFormatting.RED));
                }
            }
        } else {
            lines.add((Component)new TranslatableComponent("parttype.integrateddynamics.tooltip.inactive"));
        }
    }

    @Override
    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent(PartTypeWriteBase.this.getTranslationKey());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple<IPartContainer, PartTypeBase, PartTarget> data = PartHelpers.getContainerPartConstructionData(pos);
                IPartStateWriter partState = (IPartStateWriter)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
                return new ContainerPartWriter(id, playerInventory, (Container)partState.getInventory(), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (PartTypeWriteBase)data.getMiddle());
            }
        });
    }

    @Override
    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        packetBuffer.writeInt(this.getWriteAspects().size());
        PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return super.shouldTriggerBlockRenderUpdate(oldPartState, newPartState) || this.getStatus((IPartStateWriter)oldPartState) != this.getStatus((IPartStateWriter)newPartState);
    }
}

