/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.entity.item;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;

public class EntityItemTargetted
extends ItemEntity {
    private static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.m_135353_(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_Y = SynchedEntityData.m_135353_(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.m_135353_(EntityItemTargetted.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private LivingEntity targetEntity = null;

    public EntityItemTargetted(EntityType<? extends EntityItemTargetted> entityType, Level world) {
        super(entityType, world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(Level world, double x, double y, double z) {
        super(world, x, y, z, ItemStack.f_41583_);
        this.lifespan = Integer.MAX_VALUE;
    }

    public EntityItemTargetted(Level world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
        this.lifespan = Integer.MAX_VALUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TARGET_X, (Object)Float.valueOf((float)this.m_20186_()));
        this.m_20088_().m_135372_(TARGET_Y, (Object)Float.valueOf((float)this.m_20186_()));
        this.m_20088_().m_135372_(TARGET_Z, (Object)Float.valueOf((float)this.m_20186_()));
        this.m_20242_(true);
    }

    public void setTarget(float x, float y, float z) {
        this.m_20088_().m_135381_(TARGET_X, (Object)Float.valueOf(x));
        this.m_20088_().m_135381_(TARGET_Y, (Object)Float.valueOf(y));
        this.m_20088_().m_135381_(TARGET_Z, (Object)Float.valueOf(z));
    }

    public void setTarget(LivingEntity targetEntity) {
        this.targetEntity = targetEntity;
        this.setTarget((float)targetEntity.m_20185_(), (float)targetEntity.m_20186_(), (float)targetEntity.m_20189_());
    }

    public float getTargetX() {
        return ((Float)this.m_20088_().m_135370_(TARGET_X)).floatValue();
    }

    public float getTargetY() {
        return ((Float)this.m_20088_().m_135370_(TARGET_Y)).floatValue();
    }

    public float getTargetZ() {
        return ((Float)this.m_20088_().m_135370_(TARGET_Z)).floatValue();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.targetEntity != null) {
            this.setTarget((float)this.targetEntity.m_20185_(), (float)this.targetEntity.m_20186_(), (float)this.targetEntity.m_20189_());
        }
        double dx = this.m_20185_() - (double)this.getTargetX();
        double dy = this.m_20186_() - (double)(this.getTargetY() + 1.0f);
        double dz = this.m_20189_() - (double)this.getTargetZ();
        double strength = -0.1;
        double d = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
        if (d > 1.0) {
            double m = 1.0 / (2.0 * Math.max(1.0, d)) * strength;
            this.m_20334_(dx *= m, dy *= m, dz *= m);
            if (this.f_19862_) {
                this.m_20334_(this.m_20184_().f_82479_, 0.3, this.m_20184_().f_82481_);
            }
        }
        if (this.f_19796_.nextInt(5) == 0) {
            this.showEntityMoved();
        }
    }

    protected void showEntityMoved() {
        Random rand = this.f_19853_.f_46441_;
        float scale = 0.1f;
        float red = rand.nextFloat() * 0.2f + 0.8f;
        float green = rand.nextFloat() * 0.2f + 0.8f;
        float blue = rand.nextFloat() * 0.1f + 0.1f;
        float ageMultiplier = (float)(rand.nextDouble() * 25.0 + 50.0);
        ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.1 - (double)rand.nextFloat() * 0.2, 0.0);
        if (rand.nextInt(5) == 0) {
            double dx = this.m_20185_() - (double)(this.getTargetX() + 0.5f);
            double dy = this.m_20186_() - (double)(this.getTargetY() + 1.0f);
            double dz = this.m_20189_() - (double)(this.getTargetZ() + 0.5f);
            double factor = rand.nextDouble();
            double x = this.m_20185_() - dx * factor;
            double y = this.m_20186_() - dy * factor;
            double z = this.m_20189_() - dz * factor;
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), x, y, z, 1, -0.02 * dx, -0.02 * dy, -0.02 * dz, 0.0);
        }
    }
}

