/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.biome;

import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.extendedconfig.BiomeConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.world.gen.TreeMenril;
import org.cyclops.integrateddynamics.world.gen.feature.WorldFeatures;

public class BiomeMeneglinConfig
extends BiomeConfig {
    @ConfigurableProperty(category="biome", comment="The weight of spawning in the overworld, 0 disables spawning.", minimalValue=0)
    public static int spawnWeight = 5;
    @ConfigurableProperty(category="worldgeneration", comment="The chance at which a Menril Tree will spawn in the wild, the higher this value, the lower the chance.", minimalValue=0, requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static int wildMenrilTreeChance = 100;
    public static Holder<ConfiguredFeature<?, ?>> CONFIGURED_FEATURE_TREE;
    public static Holder<PlacedFeature> PLACED_FEATURE_MENEGLIN;
    public static Holder<PlacedFeature> PLACED_FEATURE_GENERAL;

    public BiomeMeneglinConfig() {
        super((ModBase)IntegratedDynamics._instance, "meneglin", eConfig -> {
            BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder();
            BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldFeatures.PLACED_TREES_MENEGLIN);
            biomegenerationsettings$builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, WorldFeatures.PLACED_FLOWERS_MENEGLIN);
            BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
            MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
            BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
            BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
            mobspawnsettings$builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.7f).m_47611_(0.25f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4445678).m_48037_(Helpers.RGBToInt((int)85, (int)168, (int)221)).m_48019_(12638463).m_48045_(Helpers.RGBToInt((int)85, (int)221, (int)168)).m_48043_(Helpers.RGBToInt((int)128, (int)208, (int)185)).m_48040_(Helpers.RGBToInt((int)178, (int)238, (int)233)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(null).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(biomegenerationsettings$builder.m_47831_()).m_47592_();
        });
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModSetup);
    }

    public void onConfigPropertyReload(ConfigurablePropertyData<?> configProperty, boolean reload) {
        if (!reload && configProperty.getName().equals("meneglin.spawnWeight") && spawnWeight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(this.getResourceKey(), spawnWeight));
            BiomeDictionary.addTypes((ResourceKey)this.getResourceKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
            BiomeDictionary.addTypes((ResourceKey)this.getResourceKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST});
        }
    }

    public void onModSetup(FMLCommonSetupEvent event) {
        CONFIGURED_FEATURE_TREE = WorldFeatures.registerConfigured("tree_menril", new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)TreeMenril.getMenrilTreeConfig()));
        PLACED_FEATURE_MENEGLIN = WorldFeatures.registerPlaced("tree_menril_meneglin", new PlacedFeature(CONFIGURED_FEATURE_TREE, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)1, (float)0.05f, (int)1))));
        PLACED_FEATURE_GENERAL = WorldFeatures.registerPlaced("tree_menril_general", new PlacedFeature(CONFIGURED_FEATURE_TREE, VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)0, (float)(1.0f / (float)wildMenrilTreeChance), (int)1))));
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getName().equals((Object)new ResourceLocation("integrateddynamics:meneglin"))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add(PLACED_FEATURE_MENEGLIN);
        } else if (BiomeDictionary.getTypes((ResourceKey)ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)this.getRegistry().getRegistryName()), (ResourceLocation)event.getName())).contains(BiomeDictionary.Type.OVERWORLD)) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add(PLACED_FEATURE_GENERAL);
        }
    }
}

