/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Tome;
import website.eccentric.tome.network.ConvertMessage;

public class TomeScreen
extends Screen {
    private static final int LEFT_CLICK = 0;
    private final ItemStack tome;
    private ItemStack book;

    public TomeScreen(ItemStack tome) {
        super((Component)new TextComponent(""));
        this.tome = tome;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (button != 0 || this.book == null) {
            return super.m_6375_(x, y, button);
        }
        EccentricTome.CHANNEL.sendToServer((Object)new ConvertMessage(this.book));
        this.m_7379_();
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Minecraft minecraft = this.f_96541_;
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (minecraft != null && minecraft.f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float ticks) {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        super.m_6305_(poseStack, mouseX, mouseY, ticks);
        List books = Tome.getModsBooks(this.tome).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Window window = minecraft.m_91268_();
        int booksPerRow = 6;
        int rows = books.size() / booksPerRow + 1;
        int iconSize = 20;
        int startX = window.m_85445_() / 2 - booksPerRow * iconSize / 2;
        int startY = window.m_85446_() / 2 - rows * iconSize + 45;
        int padding = 4;
        TomeScreen.m_93172_((PoseStack)poseStack, (int)(startX - padding), (int)(startY - padding), (int)(startX + iconSize * booksPerRow + padding), (int)(startY + iconSize * rows + padding), (int)0x22000000);
        this.book = null;
        int index = 0;
        for (ItemStack book : books) {
            if (book.m_150930_(Items.f_41852_)) continue;
            int stackX = startX + index % booksPerRow * iconSize;
            int stackY = startY + index / booksPerRow * iconSize;
            if (mouseX > stackX && mouseY > stackY && mouseX <= stackX + 16 && mouseY <= stackY + 16) {
                this.book = book;
            }
            minecraft.m_91291_().m_115203_(book, stackX, stackY);
            ++index;
        }
        if (this.book != null) {
            this.m_96597_(poseStack, this.m_96555_(this.book), mouseX, mouseY);
        }
    }
}

