/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.network.experience_obelisk.UpdateContents;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterFluids;
import com.cyanogen.experienceobelisk.registries.RegisterTags;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ExperienceObeliskEntity
extends BlockEntity
implements IAnimatable {
    private final AnimationFactory manager = new AnimationFactory((IAnimatable)this);
    protected boolean redstoneEnabled = false;
    protected double radius = 2.5;
    protected FluidTank tank = this.xpObeliskTank();
    private final LazyOptional<IFluidHandler> handler = LazyOptional.of(() -> this.tank);
    private static final Fluid cognitium = ((FlowingFluid)RegisterFluids.COGNITIUM.get()).m_5613_();
    public static final int capacity = (Integer)Config.COMMON.capacity.get();

    public ExperienceObeliskEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)RegisterBlockEntities.EXPERIENCEOBELISK_BE.get(), pPos, pState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        controller.transitionLengthTicks = 0.0;
        BlockEntity entity = (BlockEntity)event.getAnimatable();
        if (this.f_58857_ != null && entity instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)entity;
            if (obelisk.redstoneEnabled && !this.f_58857_.m_46753_(obelisk.m_58899_())) {
                controller.setAnimation(new AnimationBuilder().addAnimation("idle.inactive", Boolean.valueOf(true)));
                return PlayState.CONTINUE;
            }
        }
        controller.setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "experience_obelisk_block_controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.manager;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        boolean isRedstonePowered = level.m_46753_(pos);
        if (blockEntity instanceof ExperienceObeliskEntity) {
            AABB area;
            List list;
            ExperienceObeliskEntity xpobelisk = (ExperienceObeliskEntity)((Object)blockEntity);
            boolean absorb = !xpobelisk.isRedstoneEnabled() || isRedstonePowered;
            double radius = xpobelisk.getRadius();
            int space = xpobelisk.getSpace();
            if (absorb && level.m_46467_() % 10L == 0L && !(list = level.m_45976_(ExperienceOrb.class, area = new AABB((double)pos.m_123341_() - radius, (double)pos.m_123342_() - radius, (double)pos.m_123343_() - radius, (double)pos.m_123341_() + radius, (double)pos.m_123342_() + radius, (double)pos.m_123343_() + radius))).isEmpty()) {
                for (int i = 0; i < Math.min(30, list.size()); ++i) {
                    ExperienceOrb orb = (ExperienceOrb)list.get(i);
                    CompoundTag tag = new CompoundTag();
                    orb.m_7380_(tag);
                    int value = orb.f_20770_;
                    int count = tag.m_128451_("Count");
                    int amount = value * 20 * count;
                    if (space < amount) continue;
                    xpobelisk.fill(amount);
                    space -= amount;
                    orb.m_146870_();
                }
            }
        }
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean state) {
        this.redstoneEnabled = state;
        this.m_6596_();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
        super.m_6596_();
    }

    private FluidTank xpObeliskTank() {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                ExperienceObeliskEntity.this.m_6596_();
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return this.isFluidValid(stack);
            }

            public boolean isFluidValid(FluidStack stack) {
                String fluidName = String.valueOf(ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)stack.getFluid()));
                if (stack.getFluid() == cognitium) {
                    return true;
                }
                return stack.getFluid().m_205067_(RegisterTags.Fluids.EXPERIENCE) && ((List)Config.COMMON.allowedFluids.get()).contains(fluidName);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(resource)) {
                    ExperienceObeliskEntity.this.m_6596_();
                    return super.fill(new FluidStack(cognitium, resource.getAmount()), action);
                }
                return 0;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                ExperienceObeliskEntity.this.m_6596_();
                return super.drain(maxDrain, action);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                ExperienceObeliskEntity.this.m_6596_();
                return super.drain(resource, action);
            }

            public void setFluid(FluidStack stack) {
                this.fluid = stack;
                ExperienceObeliskEntity.this.m_6596_();
            }

            public int getTanks() {
                return 1;
            }
        };
    }

    public int fill(int amount) {
        return this.tank.fill(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void drain(int amount) {
        this.tank.drain(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(int amount) {
        this.tank.setFluid(new FluidStack(cognitium, amount));
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getSpace() {
        return this.tank.getSpace();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.radius = tag.m_128459_("Radius");
        this.redstoneEnabled = tag.m_128471_("isRedstoneControllable");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public static int levelsToXP(int levels) {
        if (levels <= 16) {
            return (int)(Math.pow(levels, 2.0) + (double)(6 * levels));
        }
        if (levels <= 31) {
            return (int)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        return (int)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
    }

    public static long getTotalXP(Player player) {
        return ExperienceObeliskEntity.levelsToXP(player.f_36078_) + Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public void handleRequest(UpdateContents.Request request, int XP, ServerPlayer sender) {
        long playerXP = ExperienceObeliskEntity.getTotalXP((Player)sender);
        if (request == UpdateContents.Request.FILL && this.getSpace() != 0) {
            long finalXP = ExperienceObeliskEntity.levelsToXP(sender.f_36078_ - XP) + Math.round(sender.f_36080_ * (float)(ExperienceObeliskEntity.levelsToXP(sender.f_36078_ - XP + 1) - ExperienceObeliskEntity.levelsToXP(sender.f_36078_ - XP)));
            long addAmount = (playerXP - finalXP) * 20L;
            if (addAmount >= (long)this.getSpace()) {
                sender.m_6756_(-this.fill(this.getSpace()) / 20);
            } else if (sender.f_36078_ >= XP) {
                this.fill((int)addAmount);
                sender.m_6749_(-XP);
            } else if (playerXP >= 1L) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            }
        } else if (request == UpdateContents.Request.DRAIN) {
            long finalXP;
            long drainAmount;
            int amount = this.getFluidAmount();
            if ((long)amount >= (drainAmount = ((finalXP = (long)(ExperienceObeliskEntity.levelsToXP(sender.f_36078_ + XP) + Math.round(sender.f_36080_ * (float)(ExperienceObeliskEntity.levelsToXP(sender.f_36078_ + XP + 1) - ExperienceObeliskEntity.levelsToXP(sender.f_36078_ + XP))))) - playerXP) * 20L)) {
                this.drain((int)drainAmount);
                sender.m_6749_(XP);
            } else if (amount >= 1) {
                sender.m_6756_(amount / 20);
                this.setFluid(0);
            }
        } else if (request == UpdateContents.Request.FILL_ALL) {
            if (playerXP * 20L <= (long)this.getSpace()) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            } else {
                sender.m_6756_(-this.getSpace() / 20);
                this.setFluid(capacity);
            }
        } else if (request == UpdateContents.Request.DRAIN_ALL) {
            sender.m_6756_(this.getFluidAmount() / 20);
            this.setFluid(0);
        }
    }
}

