/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.item;

import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.registries.RegisterSounds;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EnlightenedAmuletItem
extends Item {
    public EnlightenedAmuletItem(Item.Properties p) {
        super(p);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128379_("isActive", false);
        return stack;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        if (player.m_6144_()) {
            boolean isActive = tag.m_128471_("isActive");
            if (isActive) {
                tag.m_128379_("isActive", false);
                player.m_5496_((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_DEACTIVATE.get(), 0.2f, 0.8f);
            } else {
                tag.m_128379_("isActive", true);
                player.m_5496_((SoundEvent)RegisterSounds.ENLIGHTENED_AMULET_ACTIVATE.get(), 0.2f, 1.0f);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128471_("isActive");
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isCurrentItem) {
        boolean isActive = stack.m_41784_().m_128471_("isActive");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isActive && !level.f_46443_ && level.m_46467_() % 10L == 0L) {
                double radius = (Double)Config.COMMON.range.get();
                Vec3 pos = player.m_20182_();
                AABB area = new AABB(pos.m_7096_() - radius, pos.m_7098_() - radius, pos.m_7094_() - radius, pos.m_7096_() + radius, pos.m_7098_() + radius, pos.m_7094_() + radius);
                List list = level.m_45976_(ExperienceOrb.class, area);
                int totalValue = 0;
                if (!list.isEmpty()) {
                    ExperienceOrb orb;
                    for (int i = 0; i < Math.min(30, list.size()); ++i) {
                        orb = (ExperienceOrb)list.get(i);
                        CompoundTag tag = new CompoundTag();
                        orb.m_7380_(tag);
                        int value = orb.f_20770_;
                        int count = tag.m_128451_("Count");
                        totalValue += value * count;
                        orb.m_146870_();
                    }
                    ServerLevel server = (ServerLevel)level;
                    if (totalValue < 32768) {
                        orb = new ExperienceOrb((Level)server, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), totalValue);
                        server.m_7967_((Entity)orb);
                    } else {
                        while (totalValue > 0) {
                            int v = Math.min(totalValue, Short.MAX_VALUE);
                            ExperienceOrb orb2 = new ExperienceOrb((Level)server, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), v);
                            server.m_7967_((Entity)orb2);
                            totalValue -= v;
                        }
                    }
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, isCurrentItem);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean isActive = stack.m_41784_().m_128471_("isActive");
        if (isActive) {
            tooltip.add((Component)new TranslatableComponent("tooltip.experienceobelisk.enlightened_amulet.active"));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.experienceobelisk.enlightened_amulet.inactive"));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

